﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Reflection;

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.DataModelLogic.BinaryConverters;
using EffectMaker.DataModelLogic.BinaryData;
using EffectMaker.DataModelLogic.Utilities;

using ConverterParam = System.Collections.Generic.KeyValuePair<string, object>;

namespace EffectMaker.DataModelLogic.BinaryConversionInfo
{
    /// <summary>
    /// [AUTO GENERATED CLASS, DO NOT MODIFY]
    /// Auto-generated class for converting data model values.
    /// </summary>
    public class CustomActionSetting5BinaryConversionInfo : BinaryConversionInfoBase
    {
        /// <summary>The root binary structure definition.</summary>
        private static BinaryStructDefinition rootBinaryDefinition = null;

        /// <summary>The list of instance.</summary>
        private static Dictionary<DataModelBase, BinaryConversionInfoBase> instanceMap = null;

        /// <summary>The root binary structure instance.</summary>
        private BinaryStructInstance rootBinaryInstance = null;

        /// <summary>
        /// The constructor.
        /// </summary>
        static CustomActionSetting5BinaryConversionInfo()
        {
            instanceMap = new Dictionary<DataModelBase, BinaryConversionInfoBase>();

            var customActionSetting5BinaryData = new BinaryStructDefinition(typeof(CustomActionSetting5)) { HasBinaryHeader = true };

            // Output : flag0
            // Inputs : Flag0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("Flag0", new Guid("c37f3464-141f-4e3a-9adf-fce6b56e1d1c"))
            );

            // Output : intParam0
            // Inputs : IntParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam0", new Guid("a5a0c6d2-6c67-4185-87c4-739f9919a90b"))
            );

            // Output : intParam1
            // Inputs : IntParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam1", new Guid("c2723bcc-2956-4972-a154-9a4d1f304b7e"))
            );

            // Output : intParam2
            // Inputs : IntParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam2", new Guid("74abc36a-c9af-43ba-b0fa-bb64b1b391af"))
            );

            // Output : intParam3
            // Inputs : IntParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam3", new Guid("80b5a14b-64f0-4f26-a773-b531dbe65d2e"))
            );

            // Output : intParam4
            // Inputs : IntParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam4", new Guid("94a59e80-2e5b-4a4c-9baf-264312f74aef"))
            );

            // Output : intParam5
            // Inputs : IntParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("IntParam5", new Guid("2754e415-d0e8-4a00-ba30-060cbdc2ac01"))
            );

            // Output : floatParam0
            // Inputs : FloatParam0
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam0", new Guid("bcfdbb3d-c39b-40be-851c-e5d1a4353067"))
            );

            // Output : floatParam1
            // Inputs : FloatParam1
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam1", new Guid("6982115f-75a5-4955-8426-a576d365a9b7"))
            );

            // Output : floatParam2
            // Inputs : FloatParam2
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam2", new Guid("0dbb9397-def5-4dd8-bfa6-c22e12114506"))
            );

            // Output : floatParam3
            // Inputs : FloatParam3
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam3", new Guid("3cc3c1b0-4770-4c59-8fd3-1b127b0d4668"))
            );

            // Output : floatParam4
            // Inputs : FloatParam4
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam4", new Guid("7a077f82-b6fb-4856-9550-ea0020b7614d"))
            );

            // Output : floatParam5
            // Inputs : FloatParam5
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam5", new Guid("80e85c52-efa1-4e2f-b18e-e7d8b0f10690"))
            );

            // Output : floatParam6
            // Inputs : FloatParam6
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam6", new Guid("4c064732-1997-43a0-b4ac-92463f88c97b"))
            );

            // Output : floatParam7
            // Inputs : FloatParam7
            BinaryConversionInfoBase.AddBinaryFieldDefinition(
                customActionSetting5BinaryData,
                SendModificationTypes.ModifiedDataOnly,
                null,
                new ConverterDefinition(typeof(DefaultConverter)),
                null,
                new InputPropertyDefinition("FloatParam7", new Guid("94c47b3a-fe92-4cd3-8fc2-26a00ef71bc2"))
            );


            //-----------------------------------------------------------------
            // Save the binary structure definition.
            //-----------------------------------------------------------------
            rootBinaryDefinition = customActionSetting5BinaryData;
        }

        /// <summary>
        /// The constructor.
        /// </summary>
        /// <param name="dataModel">The data model to convert.</param>
        private CustomActionSetting5BinaryConversionInfo(DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public override void Dispose()
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelCreated(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }

        /// <summary>
        /// Handle DataModelCreated event from the manager.
        /// </summary>
        /// <param name="sender">The sender of the event, should be null.</param>
        /// <param name="dataModel">The created data model.</param>
        private static void OnDataModelDestroyed(object sender, DataModelBase dataModel)
        {
            /* DO_NOTHING */
        }
    }
}
