﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The user data data model class.
    /// </summary>
    [Serializable]
    public class CustomActionSetting2 : CustomActionSettingData
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionSetting2() :
            base()
        {
            this.Flag0 = 0x00000000;
            this.IntParam0 = 0;
            this.IntParam1 = 0;
            this.IntParam2 = 0;
            this.IntParam3 = 0;
            this.IntParam4 = 0;
            this.IntParam5 = 0;
            this.FloatParam0 = 0f;
            this.FloatParam1 = 0f;
            this.FloatParam2 = 0f;
            this.FloatParam3 = 0f;
            this.FloatParam4 = 0f;
            this.FloatParam5 = 0f;
            this.FloatParam6 = 0f;
            this.FloatParam7 = 0f;

            this.PostConstruct();
        }

        /// <summary>
        /// Get or set the flag value 0.
        /// </summary>
        [DataModelPropertyGuid("fe69776e-34c4-4db7-bf1c-2c5dad91702b")]
        public uint Flag0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 0.
        /// </summary>
        [DataModelPropertyGuid("6cfd3787-e668-4633-bf7c-0bf9010c0445")]
        public int IntParam0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 1.
        /// </summary>
        [DataModelPropertyGuid("2c7f7a89-9047-4e07-86b1-12e327c89b86")]
        public int IntParam1 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 2.
        /// </summary>
        [DataModelPropertyGuid("f7e4ef00-c09f-4a8b-bc37-971d42a355f5")]
        public int IntParam2 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 3.
        /// </summary>
        [DataModelPropertyGuid("7770d219-96e4-4486-a380-b40cb235f173")]
        public int IntParam3 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 4.
        /// </summary>
        [DataModelPropertyGuid("09dcc1bc-db8f-4b6f-8839-14a376effe79")]
        public int IntParam4 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 5.
        /// </summary>
        [DataModelPropertyGuid("1ab39ade-f8cf-4353-bd44-b51265f37dea")]
        public int IntParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 0.
        /// </summary>
        [DataModelPropertyGuid("aa1f26b8-bd76-45d3-baad-939e77c6e800")]
        public float FloatParam0 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 1.
        /// </summary>
        [DataModelPropertyGuid("34963614-c742-4ca4-ba0c-3e7b05926fb4")]
        public float FloatParam1 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 2.
        /// </summary>
        [DataModelPropertyGuid("93d306df-496d-4f57-ae8b-9d7b2d5b0186")]
        public float FloatParam2 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 3.
        /// </summary>
        [DataModelPropertyGuid("b2aef49c-fe1c-45cd-a63d-1856299bfcc4")]
        public float FloatParam3 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 4.
        /// </summary>
        [DataModelPropertyGuid("bf4407cc-e329-4569-964b-bf3331ff469f")]
        public float FloatParam4 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 5.
        /// </summary>
        [DataModelPropertyGuid("41917e49-f870-474d-a1b0-e18a8aa1779c")]
        public float FloatParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 6.
        /// </summary>
        [DataModelPropertyGuid("35dbd486-8722-40ee-ac86-47256f41b335")]
        public float FloatParam6 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 7.
        /// </summary>
        [DataModelPropertyGuid("1fd8bbe0-ab99-44c9-b0c7-94c152a6d2bc")]
        public float FloatParam7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomActionSetting2;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Flag0 = srcDataModel.Flag0;
            this.IntParam0 = srcDataModel.IntParam0;
            this.IntParam1 = srcDataModel.IntParam1;
            this.IntParam2 = srcDataModel.IntParam2;
            this.IntParam3 = srcDataModel.IntParam3;
            this.IntParam4 = srcDataModel.IntParam4;
            this.IntParam5 = srcDataModel.IntParam5;
            this.FloatParam0 = srcDataModel.FloatParam0;
            this.FloatParam1 = srcDataModel.FloatParam1;
            this.FloatParam2 = srcDataModel.FloatParam2;
            this.FloatParam3 = srcDataModel.FloatParam3;
            this.FloatParam4 = srcDataModel.FloatParam4;
            this.FloatParam5 = srcDataModel.FloatParam5;
            this.FloatParam6 = srcDataModel.FloatParam6;
            this.FloatParam7 = srcDataModel.FloatParam7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Flag0", this.Flag0);
            this.WriteElement(context, "IntParam0", this.IntParam0);
            this.WriteElement(context, "IntParam1", this.IntParam1);
            this.WriteElement(context, "IntParam2", this.IntParam2);
            this.WriteElement(context, "IntParam3", this.IntParam3);
            this.WriteElement(context, "IntParam4", this.IntParam4);
            this.WriteElement(context, "IntParam5", this.IntParam5);
            this.WriteElement(context, "FloatParam0", this.FloatParam0);
            this.WriteElement(context, "FloatParam1", this.FloatParam1);
            this.WriteElement(context, "FloatParam2", this.FloatParam2);
            this.WriteElement(context, "FloatParam3", this.FloatParam3);
            this.WriteElement(context, "FloatParam4", this.FloatParam4);
            this.WriteElement(context, "FloatParam5", this.FloatParam5);
            this.WriteElement(context, "FloatParam6", this.FloatParam6);
            this.WriteElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Flag0 = this.ReadElement(context, "Flag0", this.Flag0);
            this.IntParam0 = this.ReadElement(context, "IntParam0", this.IntParam0);
            this.IntParam1 = this.ReadElement(context, "IntParam1", this.IntParam1);
            this.IntParam2 = this.ReadElement(context, "IntParam2", this.IntParam2);
            this.IntParam3 = this.ReadElement(context, "IntParam3", this.IntParam3);
            this.IntParam4 = this.ReadElement(context, "IntParam4", this.IntParam4);
            this.IntParam5 = this.ReadElement(context, "IntParam5", this.IntParam5);
            this.FloatParam0 = this.ReadElement(context, "FloatParam0", this.FloatParam0);
            this.FloatParam1 = this.ReadElement(context, "FloatParam1", this.FloatParam1);
            this.FloatParam2 = this.ReadElement(context, "FloatParam2", this.FloatParam2);
            this.FloatParam3 = this.ReadElement(context, "FloatParam3", this.FloatParam3);
            this.FloatParam4 = this.ReadElement(context, "FloatParam4", this.FloatParam4);
            this.FloatParam5 = this.ReadElement(context, "FloatParam5", this.FloatParam5);
            this.FloatParam6 = this.ReadElement(context, "FloatParam6", this.FloatParam6);
            this.FloatParam7 = this.ReadElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }
    }
}
