﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using EffectMaker.DataModel.Attributes;
using EffectMaker.DataModel.DataModels;
using EffectMaker.DataModel.Extensions;
using EffectMaker.DataModel.Specific.DataModels;
using EffectMaker.Foundation.Serialization;
using System;
using System.Linq;
using System.Xml.Serialization;

using CurrVersion = EffectMaker.DataModel.Specific.DataModels;
using CurrVersionSerializer = EffectMaker.DataModel.Specific.Serializer;

namespace EffectMaker.DataModel.Specific.DataModels
{
    /// <summary>
    /// [AUTO GENERATED SOURCE CODE, DO NOT MODIFY]
    /// The user data data model class.
    /// </summary>
    [Serializable]
    public class CustomActionSetting1 : CustomActionSettingData
    {
        /// <summary>
        /// コンストラクタです.
        /// </summary>
        public CustomActionSetting1() :
            base()
        {
            this.Flag0 = 0x00000000;
            this.IntParam0 = 0;
            this.IntParam1 = 0;
            this.IntParam2 = 0;
            this.IntParam3 = 0;
            this.IntParam4 = 0;
            this.IntParam5 = 0;
            this.FloatParam0 = 0f;
            this.FloatParam1 = 0f;
            this.FloatParam2 = 0f;
            this.FloatParam3 = 0f;
            this.FloatParam4 = 0f;
            this.FloatParam5 = 0f;
            this.FloatParam6 = 0f;
            this.FloatParam7 = 0f;

            this.PostConstruct();
        }

        /// <summary>
        /// Get or set the flag value 0.
        /// </summary>
        [DataModelPropertyGuid("02ae978f-4ecc-4bc4-9a47-cf4af11bdf2d")]
        public uint Flag0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 0.
        /// </summary>
        [DataModelPropertyGuid("6d9d6902-3c56-4684-99be-1874f4469f07")]
        public int IntParam0 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 1.
        /// </summary>
        [DataModelPropertyGuid("92790333-6a6f-40c3-ba2a-805a26f46de4")]
        public int IntParam1 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 2.
        /// </summary>
        [DataModelPropertyGuid("a946e754-d746-485e-a198-428f9bb9db01")]
        public int IntParam2 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 3.
        /// </summary>
        [DataModelPropertyGuid("e2bf0050-2e4d-4c15-94be-5ae3c1519fd0")]
        public int IntParam3 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 4.
        /// </summary>
        [DataModelPropertyGuid("e26f2a74-7bed-4d01-8dd2-bdb7462742e7")]
        public int IntParam4 { get; set; }

        /// <summary>
        /// Get or set the integer parameter 5.
        /// </summary>
        [DataModelPropertyGuid("e170aa93-44f5-4f23-99dd-dd913e4b568c")]
        public int IntParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 0.
        /// </summary>
        [DataModelPropertyGuid("699598d6-d309-4faf-ae6a-d7b5d1c90ea0")]
        public float FloatParam0 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 1.
        /// </summary>
        [DataModelPropertyGuid("d1b3effe-df1f-4354-b2b7-0dd6eb622497")]
        public float FloatParam1 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 2.
        /// </summary>
        [DataModelPropertyGuid("f2b1a382-8768-43cd-802c-54fc1abc7b4f")]
        public float FloatParam2 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 3.
        /// </summary>
        [DataModelPropertyGuid("777e7fa4-e56d-42da-b463-e22a19b6d2d5")]
        public float FloatParam3 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 4.
        /// </summary>
        [DataModelPropertyGuid("44eeda7b-2309-4f14-81bb-3b798b206f35")]
        public float FloatParam4 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 5.
        /// </summary>
        [DataModelPropertyGuid("087bd3b0-8100-40af-a6d7-06ce1f246006")]
        public float FloatParam5 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 6.
        /// </summary>
        [DataModelPropertyGuid("10b1ebac-03df-4301-9936-9457a1d8c284")]
        public float FloatParam6 { get; set; }

        /// <summary>
        /// Get or set the floating point parameter 7.
        /// </summary>
        [DataModelPropertyGuid("eb08f869-0606-447f-afc1-41d4257cee4f")]
        public float FloatParam7 { get; set; }

        /// <summary>
        /// 入力データモデルからの値を設定します.
        /// </summary>
        /// <param name="src">入力データモデルです.</param>
        /// <returns>設定に成功したらtrueを返却します.</returns>
        public override bool Set(object src)
        {
            var srcDataModel = src as CurrVersion.CustomActionSetting1;
            if (srcDataModel == null)
            {
                return false;
            }

            if (base.Set(src) == false)
            {
                return false;
            }

            this.Flag0 = srcDataModel.Flag0;
            this.IntParam0 = srcDataModel.IntParam0;
            this.IntParam1 = srcDataModel.IntParam1;
            this.IntParam2 = srcDataModel.IntParam2;
            this.IntParam3 = srcDataModel.IntParam3;
            this.IntParam4 = srcDataModel.IntParam4;
            this.IntParam5 = srcDataModel.IntParam5;
            this.FloatParam0 = srcDataModel.FloatParam0;
            this.FloatParam1 = srcDataModel.FloatParam1;
            this.FloatParam2 = srcDataModel.FloatParam2;
            this.FloatParam3 = srcDataModel.FloatParam3;
            this.FloatParam4 = srcDataModel.FloatParam4;
            this.FloatParam5 = srcDataModel.FloatParam5;
            this.FloatParam6 = srcDataModel.FloatParam6;
            this.FloatParam7 = srcDataModel.FloatParam7;

            return true;
        }

        /// <summary>
        /// Write the data model to XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for serialization.</param>
        /// <returns>True on success.</returns>
        public override bool WriteXml(XmlDocSerializationContext context)
        {
            // Serialize the base class.
            bool success = base.WriteXml(context);

            this.WriteElement(context, "Flag0", this.Flag0);
            this.WriteElement(context, "IntParam0", this.IntParam0);
            this.WriteElement(context, "IntParam1", this.IntParam1);
            this.WriteElement(context, "IntParam2", this.IntParam2);
            this.WriteElement(context, "IntParam3", this.IntParam3);
            this.WriteElement(context, "IntParam4", this.IntParam4);
            this.WriteElement(context, "IntParam5", this.IntParam5);
            this.WriteElement(context, "FloatParam0", this.FloatParam0);
            this.WriteElement(context, "FloatParam1", this.FloatParam1);
            this.WriteElement(context, "FloatParam2", this.FloatParam2);
            this.WriteElement(context, "FloatParam3", this.FloatParam3);
            this.WriteElement(context, "FloatParam4", this.FloatParam4);
            this.WriteElement(context, "FloatParam5", this.FloatParam5);
            this.WriteElement(context, "FloatParam6", this.FloatParam6);
            this.WriteElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }

        /// <summary>
        /// Read the data model from XML document.
        /// </summary>
        /// <param name="context">Holds the data needed for deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            // Deserialize the base class.
            bool success = base.ReadXml(context);

            this.Flag0 = this.ReadElement(context, "Flag0", this.Flag0);
            this.IntParam0 = this.ReadElement(context, "IntParam0", this.IntParam0);
            this.IntParam1 = this.ReadElement(context, "IntParam1", this.IntParam1);
            this.IntParam2 = this.ReadElement(context, "IntParam2", this.IntParam2);
            this.IntParam3 = this.ReadElement(context, "IntParam3", this.IntParam3);
            this.IntParam4 = this.ReadElement(context, "IntParam4", this.IntParam4);
            this.IntParam5 = this.ReadElement(context, "IntParam5", this.IntParam5);
            this.FloatParam0 = this.ReadElement(context, "FloatParam0", this.FloatParam0);
            this.FloatParam1 = this.ReadElement(context, "FloatParam1", this.FloatParam1);
            this.FloatParam2 = this.ReadElement(context, "FloatParam2", this.FloatParam2);
            this.FloatParam3 = this.ReadElement(context, "FloatParam3", this.FloatParam3);
            this.FloatParam4 = this.ReadElement(context, "FloatParam4", this.FloatParam4);
            this.FloatParam5 = this.ReadElement(context, "FloatParam5", this.FloatParam5);
            this.FloatParam6 = this.ReadElement(context, "FloatParam6", this.FloatParam6);
            this.FloatParam7 = this.ReadElement(context, "FloatParam7", this.FloatParam7);

            return success;
        }
    }
}
