﻿/// <tag name="Convert">
///  <func id="ConvV4ToV3"/>
/// </tag>
/// <func id="ConvV4ToV3" name="ConvV4ToV3">
///  <in name="v4" type="vec4"/>
///  <return type="vec3"/>
///  <description>vec4 から vec3 を抽出</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47660F4942B6}" displayname="V4 => V3 [xyz]">
///  <func id="ConvV4ToV3"/>
///  <in displayname="xyzw" type="vec4" target="v4"/>
///  <out displayname="xyz" type="vec3" target="return"/>
/// </block>
vec3 ConvV4ToV3( vec4 v4 )
{
  return v4.xyz;
}


/// <tag name="Convert">
///  <func id="ConvV4ToV2"/>
/// </tag>
/// <func id="ConvV4ToV2" name="ConvV4ToV2">
///  <in name="v4" type="vec4"/>
///  <return type="vec2"/>
///  <description>vec4 から vec2(xy) を抽出</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47650F4842B6}" displayname="V4 => V2 [xy]">
///  <func id="ConvV4ToV2"/>
///  <in displayname="xyzw" type="vec4" target="v4"/>
///  <out displayname="xy" type="vec2" target="return"/>
/// </block>
vec2 ConvV4ToV2( vec4 v4 )
{
  return v4.xy;
}


/// <tag name="Convert">
///  <func id="ConvV4ToV2_XW"/>
/// </tag>
/// <func id="ConvV4ToV2_XW" name="ConvV4ToV2_XW">
///  <in name="v4" type="vec4"/>
///  <return type="vec2"/>
///  <description>vec4 から vec2(xw) を抽出</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47650F4842B7}" displayname="V4 => V2 [xw]">
///  <func id="ConvV4ToV2_XW"/>
///  <in displayname="xyzw" type="vec4" target="v4"/>
///  <out displayname="xw" type="vec2" target="return"/>
/// </block>
vec2 ConvV4ToV2_XW( vec4 v4 )
{
  return v4.xw;
}


/// <tag name="Convert">
///  <func id="ConvV3ToV4_0"/>
/// </tag>
/// <func id="ConvV3ToV4_0" name="ConvV3ToV4_0">
///  <in name="v3" type="vec3"/>
///  <return type="vec4"/>
///  <description>vec3 を w=0 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB1B-B09A-439d-955A-47650F4842B5}" displayname="V3 => V4 [0]">
///  <func id="ConvV3ToV4_0"/>
///  <in displayname="xyz" type="vec3" target="v3"/>
///  <out displayname="xyz0" type="vec4" target="return"/>
/// </block>
vec4 ConvV3ToV4_0( vec3 v3 )
{
  return vec4( v3, 0 );
}


/// <tag name="Convert">
///  <func id="ConvV3ToV4_1"/>
/// </tag>
/// <func id="ConvV3ToV4_1" name="ConvV3ToV4_1">
///  <in name="v3" type="vec3"/>
///  <return type="vec4"/>
///  <description>vec3 を w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47651F4842B5}" displayname="V3 => V4 [1]">
///  <func id="ConvV3ToV4_1"/>
///  <in displayname="xyz" type="vec3" target="v3"/>
///  <out displayname="xyz1" type="vec4" target="return"/>
/// </block>
vec4 ConvV3ToV4_1( vec3 v3 )
{
  return vec4( v3, 1 );
}

/// <tag name="Convert">
///  <func id="ConvV2ToV4_0"/>
/// </tag>
/// <func id="ConvV2ToV4_0" name="ConvV2ToV4_0">
///  <in name="v2" type="vec2"/>
///  <return type="vec4"/>
///  <description>vec2 を z=0, w=0 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-956A-47650F4842B5}" displayname="V2 => V4 [00]">
///  <func id="ConvV2ToV4_0"/>
///  <in displayname="xy" type="vec2" target="v2"/>
///  <out displayname="xy00" type="vec4" target="return"/>
/// </block>
vec4 ConvV2ToV4_0( vec2 v2 )
{
  return vec4( v2, 0, 0 );
}

/// <tag name="Convert">
///  <func id="ConvV2ToV4_01"/>
/// </tag>
/// <func id="ConvV2ToV4_01" name="ConvV2ToV4_01">
///  <in name="v2" type="vec2"/>
///  <return type="vec4"/>
///  <description>vec2 を z=0, w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{FD3D2595-FBC9-4D16-8B78-50189DC96B30}" displayname="V2 => V4 [01]">
///  <func id="ConvV2ToV4_01"/>
///  <in displayname="xy" type="vec2" target="v2"/>
///  <out displayname="xy01" type="vec4" target="return"/>
/// </block>
vec4 ConvV2ToV4_01( vec2 v2 )
{
  return vec4( v2, 0, 1 );
}


/// <tag name="Convert">
///  <func id="ConvV2ToV4_1"/>
/// </tag>
/// <func id="ConvV2ToV4_1" name="ConvV2ToV4_1">
///  <in name="v2" type="vec2"/>
///  <return type="vec4"/>
///  <description>vec2 を z=1, w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{7C94EB0B-B09A-439d-955A-47650F4842B5}" displayname="V2 => V4 [11]">
///  <func id="ConvV2ToV4_1"/>
///  <in displayname="xy" type="vec2" target="v2"/>
///  <out displayname="xy11" type="vec4" target="return"/>
/// </block>
vec4 ConvV2ToV4_1( vec2 v2 )
{
  return vec4( v2, 1, 1 );
}

/// <tag name="Convert">
///  <func id="ConvFloatToV4_1"/>
/// </tag>
/// <func id="ConvFloatToV4_1" name="ConvFloatToV4_1">
///  <in name="v1" type="float"/>
///  <return type="vec4"/>
///  <description>float を x = v1, y = v1, z=v1, w=1 とした vec4 に変換</description>
/// </func>
/// <block guid="{2E09BAA6-F5E9-4CE0-AEB0-6A681639FC6A}" displayname="V1 => V4 [vvv1]">
///  <func id="ConvFloatToV4_1"/>
///  <in displayname="v" type="float" target="v1"/>
///  <out displayname="vvv1" type="vec4" target="return"/>
/// </block>
vec4 ConvFloatToV4_1( float v1 )
{
  return vec4( v1, v1, v1, 1);
}

