﻿/// <tag name="Utility">
///  <func id="Cook_TorranceReflectionModel"/>
/// </tag>
/// <func id="Cook_TorranceReflectionModel" name="Cook_TorranceReflectionModel">
///  <in name="lightColor" type="vec3"/>
///  <in name="reflectColor" type="vec3"/>
///  <in name="lightDir" type="vec3"/>
///  <in name="lookDir" type="vec3"/>
///  <in name="norm" type="vec3"/>
///  <in name="phongCoeff" type="float"/>
///  <return type="vec3"/>
///  <description>【試験機能】Cook-Torranceモデルの鏡面反射を計算</description>
/// </func>
/// <block guid="{3F7C84B3-BCB9-520b-95C8-5DCA7F4A38A2}" displayname="Cook_TorranceReflection">
///  <func id="Cook_TorranceReflectionModel"/>
///  <in displayname="Light Color" type="vec3" target="lightColor"/>
///  <in displayname="Reflect Color" type="vec3" target="reflectColor"/>
///  <in displayname="Light Dir" type="vec3" target="lightDir"/>
///  <in displayname="Look Dir" type="vec3" target="lookDir"/>
///  <in displayname="Normal" type="vec3" target="norm"/>
///  <in displayname="Phong Coeff" type="float" target="phongCoeff"/>
///  <out displayname="RGB" type="vec3" target="return"/>
/// </block>
vec3 Cook_TorranceReflectionModel(vec3 lightColor, vec3 reflectColor, vec3 lightDir, vec3 lookDir, vec3 norm, float phongCoeff)
{
  // Cook-Torrance Reflection Model

  lightDir = normalize( -lightDir );
  lookDir = normalize( -lookDir );

  float m = phongCoeff;
  vec3 V = lookDir;
  vec3 N = norm;
  vec3 L = lightDir;
  vec3 H = normalize( lightDir + lookDir );

  float dotNL = dot( N, L );
  float dotNV = dot( N, V );
  float dotNH = dot( N, H );
  float dotVH = dot( V, H );

  float n = 1.5443;
  float c = dotVH;
  float g = sqrt( n*n + c*c - 1 );
  float gpc = g + c;
  float gmc = g - c;

  float D = 0;
  {
    float sqm = m * m;
    float sqNH = dotNH * dotNH;
    D = ( 1.0 / ( 4 * sqm * sqNH * sqNH ) ) * exp( ( sqNH - 1 ) / ( sqm * sqNH ) );
  }

  float G = 0;
  {
    G = min( 1, min( ( 2 * dotNH * dotNV / dotVH ), ( 2 * dotNH * dotNL / dotVH ) ) );
  }

  float F = 0;
  {
    float temp1 = (c * gpc) - 1;
    float temp2 = (c * gmc) - 1;
    F = ( gmc * gmc ) / ( gpc * gpc ) * ( 1 + (temp1 * temp1)/(temp2 * temp2) );
  }

  return lightColor * reflectColor * ( ( D * G * F ) / dotNV );
}

