﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Workflow.Core
{
    public class NameChangedEventArgs : EventArgs
    {
        public string OldName { get; private set; }
        public string NewName { get; private set; }

        public NameChangedEventArgs(string oldName, string newName)
        {
            OldName = oldName;
            NewName = newName;
        }
    }

    public class ValueChangedEventArgs<T> : EventArgs
    {
        public T OldValue { get; private set; }
        public T NewValue { get; private set; }

        public ValueChangedEventArgs(T oldValue, T newValue)
        {
            OldValue = oldValue;
            NewValue = newValue;
        }
    }

    public class InputPlugEventArgs<T> : EventArgs
    {
        public InputPlug<T> InputPlug { get; private set; }

        public InputPlugEventArgs(InputPlug<T> inputPlug)
        {
            if (inputPlug == null)
                throw new ArgumentNullException("inputPlug");

            InputPlug = inputPlug;
        }
    }

    public class OutputPlugEventArgs<T> : EventArgs
    {
        public OutputPlug<T> OutputPlug { get; private set; }

        public OutputPlugEventArgs(OutputPlug<T> outputPlug)
        {
            if (outputPlug == null)
                throw new ArgumentNullException("outputPlug");

            OutputPlug = outputPlug;
        }
    }

    public class OutputPlugChangedEventArgs<T> : EventArgs
    {
        public OutputPlug<T> OldOutputPlug { get; private set; }
        public OutputPlug<T> NewOutputPlug { get; private set; }

        public OutputPlugChangedEventArgs(OutputPlug<T> oldOutputPlug, OutputPlug<T> newOutputPlug)
        {
            OldOutputPlug = oldOutputPlug;
            NewOutputPlug = newOutputPlug;
        }
    }

    public class WorkflowItemChangedEventArgs<T> : EventArgs
    {
        public WorkflowItem<T> OldWorkflowItem { get; private set; }
        public WorkflowItem<T> NewWorkflowItem { get; private set; }

        public WorkflowItemChangedEventArgs(WorkflowItem<T> oldWorkflowItem, WorkflowItem<T> newWorkflowItem)
        {
            OldWorkflowItem = oldWorkflowItem;
            NewWorkflowItem = newWorkflowItem;
        }
    }
}
