﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Workflow.Core;

namespace UnitTests
{
    [TestClass]
    public class WorkflowCoreConnectionManager
    {
        [TestMethod]
        public void CircularReferenceTest1()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");
            var c = new DummyWorkflowItem("C");
            var d = new DummyWorkflowItem("D");

            ConnectionManager.Connect(a.OutputPlugs[0], c.InputPlugs[0]);
            ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[1]);
            ConnectionManager.Connect(c.OutputPlugs[0], b.InputPlugs[0]);
            ConnectionManager.Connect(b.OutputPlugs[0], d.InputPlugs[0]);

            if (ConnectionManager.CheckCircularReference(d.OutputPlugs[0], a.InputPlugs[0]) == false)
                throw new Exception();
        }

        [TestMethod]
        public void CircularReferenceTest2()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");
            var c = new DummyWorkflowItem("C");
            var d = new DummyWorkflowItem("D");

            ConnectionManager.Connect(a.OutputPlugs[0], c.InputPlugs[0]);
            ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[1]);
            ConnectionManager.Connect(c.OutputPlugs[0], b.InputPlugs[0]);
            ConnectionManager.Connect(b.OutputPlugs[0], d.InputPlugs[0]);

            if (ConnectionManager.CheckCircularReference(d, a) == false)
                throw new Exception();
        }

        [TestMethod]
        public void CircularReferenceTest3()
        {
            var input = new InputPlug<object>();
            var output = new OutputPlug<object>();

            if (ConnectionManager.CheckCircularReference(output, input))
                throw new Exception();
        }

        [TestMethod]
        public void CircularReferenceTest4()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            if (ConnectionManager.CheckCircularReference(a, b))
                throw new Exception();
        }

        [TestMethod]
        public void CircularReferenceTest5()
        {
            var a = new DummyWorkflowItem("A");

            if (ConnectionManager.CheckCircularReference(a, a) == false)
                throw new Exception();
        }

        [TestMethod]
        public void CircularReferenceTest6()
        {
            var a = new DummyWorkflowItem("A");

            if (ConnectionManager.CheckCircularReference(a.OutputPlugs[0], a.InputPlugs[1]) == false)
                throw new Exception();
        }

        [TestMethod]
        public void CircularReferenceTest7()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");
            var c1 = new DummyWorkflowItem("C1");
            var c2 = new DummyWorkflowItem("C2");
            var d = new DummyWorkflowItem("D");

            if (ConnectionManager.CheckCircularReference(b.OutputPlugs[0], c1.InputPlugs[0]))
                throw new Exception();
            if (ConnectionManager.CheckCircularReference(b.OutputPlugs[1], c2.InputPlugs[0]))
                throw new Exception();
            if (ConnectionManager.CheckCircularReference(c1.OutputPlugs[0], d.InputPlugs[0]))
                throw new Exception();
            if (ConnectionManager.CheckCircularReference(c2.OutputPlugs[0], d.InputPlugs[1]))
                throw new Exception();
            if (ConnectionManager.CheckCircularReference(a.OutputPlugs[0], b.InputPlugs[0]))
                throw new Exception();
        }

        // ==================================================================================================================================================

        [TestMethod]
        public void ConnectTest1()
        {
            var a = new DummyWorkflowItem("A");

            var ok = false;
            try
            {
                ConnectionManager.Connect(a.OutputPlugs[0], a.InputPlugs[1]);
            }
            catch
            {
                ok = true;
            }

            if (ok == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(a.InputPlugs[1]))
                throw new Exception();
            if (a.InputPlugs[1].RemoteOutputPlug != null)
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest2()
        {
            var a = new DummyWorkflowItem("A");
            var outputPlug = new OutputPlug<object>();

            ConnectionManager.Connect(outputPlug, a.InputPlugs[1]);

            if (outputPlug.RemoteInputPlugs.Contains(a.InputPlugs[1]) == false)
                throw new Exception();
            if (a.InputPlugs[1].RemoteOutputPlug != outputPlug)
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest3()
        {
            var a = new DummyWorkflowItem("A");
            var inputPlug = new InputPlug<object>();

            ConnectionManager.Connect(a.OutputPlugs[1], inputPlug);

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(inputPlug) == false)
                throw new Exception();
            if (inputPlug.RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest4()
        {
            var inputPlug = new InputPlug<object>();
            var outputPlug = new OutputPlug<object>();

            ConnectionManager.Connect(outputPlug, inputPlug);

            if (outputPlug.RemoteInputPlugs.Contains(inputPlug) == false)
                throw new Exception();
            if (inputPlug.RemoteOutputPlug != outputPlug)
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest5()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest6()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);
            ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[1]);

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(b.InputPlugs[1]) == false)
                throw new Exception();
            if (b.InputPlugs[1].RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest7()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[0]);

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]))
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();
        }

        [TestMethod]
        public void ConnectTest8()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            var ok = false;
            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            try
            {
                ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[0], false);
            }
            catch
            {
                ok = true;
            }

            if (ok == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(b.InputPlugs[0]))
                throw new Exception();
            if (b.InputPlugs[1].RemoteOutputPlug == a.OutputPlugs[0])
                throw new Exception();
        }

        // ==================================================================================================================================================

        [TestMethod]
        public void TryConnectTest1()
        {
            var a = new DummyWorkflowItem("A");

            if (ConnectionManager.TryConnect(a.OutputPlugs[0], a.InputPlugs[1]))
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(a.InputPlugs[1]))
                throw new Exception();

            if (a.InputPlugs[1].RemoteOutputPlug != null)
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest2()
        {
            var a = new DummyWorkflowItem("A");
            var outputPlug = new OutputPlug<object>();

            if (ConnectionManager.TryConnect(outputPlug, a.InputPlugs[1]) == false)
                throw new Exception();

            if (outputPlug.RemoteInputPlugs.Contains(a.InputPlugs[1]) == false)
                throw new Exception();

            if (a.InputPlugs[1].RemoteOutputPlug != outputPlug)
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest3()
        {
            var a = new DummyWorkflowItem("A");
            var inputPlug = new InputPlug<object>();

            if (ConnectionManager.TryConnect(a.OutputPlugs[1], inputPlug) == false)
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(inputPlug) == false)
                throw new Exception();

            if (inputPlug.RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest4()
        {
            var inputPlug = new InputPlug<object>();
            var outputPlug = new OutputPlug<object>();

            if (ConnectionManager.TryConnect(outputPlug, inputPlug) == false)
                throw new Exception();

            if (outputPlug.RemoteInputPlugs.Contains(inputPlug) == false)
                throw new Exception();

            if (inputPlug.RemoteOutputPlug != outputPlug)
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest5()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            if (ConnectionManager.TryConnect(a.OutputPlugs[0], b.InputPlugs[0]) == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();

            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest6()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            if (ConnectionManager.TryConnect(a.OutputPlugs[0], b.InputPlugs[0]) == false)
                throw new Exception();
            if (ConnectionManager.TryConnect(a.OutputPlugs[1], b.InputPlugs[1]) == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(b.InputPlugs[1]) == false)
                throw new Exception();
            if (b.InputPlugs[1].RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest7()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            if (ConnectionManager.TryConnect(a.OutputPlugs[0], b.InputPlugs[0]) == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            if (ConnectionManager.TryConnect(a.OutputPlugs[1], b.InputPlugs[0]) == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]))
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[1])
                throw new Exception();
        }

        [TestMethod]
        public void TryConnectTest8()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            if (ConnectionManager.TryConnect(a.OutputPlugs[0], b.InputPlugs[0]) == false)
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            if (ConnectionManager.TryConnect(a.OutputPlugs[1], b.InputPlugs[0], false))
                throw new Exception();

            if (a.OutputPlugs[0].RemoteInputPlugs.Contains(b.InputPlugs[0]) == false)
                throw new Exception();
            if (b.InputPlugs[0].RemoteOutputPlug != a.OutputPlugs[0])
                throw new Exception();

            if (a.OutputPlugs[1].RemoteInputPlugs.Contains(b.InputPlugs[0]))
                throw new Exception();
            if (b.InputPlugs[1].RemoteOutputPlug == a.OutputPlugs[0])
                throw new Exception();
        }

        // ==================================================================================================================================================

        [TestMethod]
        public void DisconnectTest1()
        {
            var a = new DummyWorkflowItem("A");

            ConnectionManager.Disconnect(a.InputPlugs[1]);
        }

        [TestMethod]
        public void DisconnectTest2()
        {
            var a = new DummyWorkflowItem("A");
            var outputPlug = new OutputPlug<object>();

            ConnectionManager.Connect(outputPlug, a.InputPlugs[1]);
            ConnectionManager.Disconnect(a.InputPlugs[1]);

            if (a.InputPlugs[1].RemoteOutputPlug != null)
                throw new Exception();
        }

        [TestMethod]
        public void DisconnectTest3()
        {
            var a = new DummyWorkflowItem("A");
            var inputPlug = new InputPlug<object>();

            ConnectionManager.Connect(a.OutputPlugs[1], inputPlug);
            ConnectionManager.Disconnect(inputPlug);
        }

        [TestMethod]
        public void DisconnectTest4()
        {
            var inputPlug = new InputPlug<object>();
            var outputPlug = new OutputPlug<object>();

            ConnectionManager.Connect(outputPlug, inputPlug);
        }

        [TestMethod]
        public void DisconnectTest5()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);
        }

        [TestMethod]
        public void DisconnectTest6()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);
            ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[1]);
        }

        [TestMethod]
        public void DisconnectTest7()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);
            ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[0]);
        }

        [TestMethod]
        public void DisconnectTest8()
        {
            var a = new DummyWorkflowItem("A");
            var b = new DummyWorkflowItem("B");

            ConnectionManager.Connect(a.OutputPlugs[0], b.InputPlugs[0]);
            try
            {
                ConnectionManager.Connect(a.OutputPlugs[1], b.InputPlugs[0], false);
            }
            catch
            {
                return;
            }

            throw new Exception();
        }
    }
}
