﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing.Imaging;
using System.Runtime.InteropServices;

namespace Renderer2D.GDI
{
    public class GDIBitmapContainer : Core.IBitmap
    {
        public System.Drawing.Bitmap NativeBitmap { get; private set; }

        public GDIBitmapContainer(Core.IBitmapDefinition definition)
        {
            NativeBitmap = new System.Drawing.Bitmap((int)definition.Size.Width,
                                                     (int)definition.Size.Height,
                                                     PixelFormat.Format32bppArgb);

            var rect = new System.Drawing.Rectangle(0, 0, (int)definition.Size.Width, (int)definition.Size.Height);
            var bitmapData = NativeBitmap.LockBits(rect, ImageLockMode.WriteOnly, PixelFormat.Format32bppArgb);

            try
            {
                Marshal.Copy(definition.Data, 0, bitmapData.Scan0, definition.Data.Length);
            }
            finally
            {
                NativeBitmap.UnlockBits(bitmapData);
            }

            Size = definition.Size;
        }

        public Core.ISize Size { get; private set; }
    }
}
