﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Renderer2D.Core
{
    public enum FontStretch
    {
        Undefined,
        UltraCondensed,
        ExtraCondensed,
        Condensed,
        SemiCondensed,
        Normal,
        Medium,
        SemiExpanded,
        Expanded,
        ExtraExpanded,
        UltraExpanded,
    }

    public enum FontStyle
    {
        Normal,
        Oblique,
        Italic,
    }

    public enum FontWeight
    {
        Thin,
        ExtraLight,
        UltraLight,
        Light,
        Normal,
        Regular,
        Medium,
        DemiBold,
        SemiBold,
        Bold,
        ExtraBold,
        UltraBold,
        Black,
        Heavy,
        ExtraBlack,
        UltraBlack,
    }

    public interface IFont
    {
        string FamilyName { get; set; }
        double Size { get; set; }
        FontStretch Stretch { get; set; }
        FontStyle Style { get; set; }
        FontWeight Weight { get; set; }
    }

    public class Font : IFont
    {
        public static readonly IFont Default = new Font("メイリオ", 9.0);

        public Font(string familyName, double size)
            : this(familyName, size, FontStretch.Normal, FontStyle.Normal, FontWeight.Normal)
        {
        }

        public Font(string familyName, double size, FontStretch stretch, FontStyle style, FontWeight weight)
        {
            if (string.IsNullOrWhiteSpace(familyName))
                throw new ArgumentException(string.Format(Messages.EXCEPTION_INVALID_ARGUMENT, "familyName"), "familyName");

            FamilyName = familyName;
            Size = size;
            Stretch = stretch;
            Style = style;
            Weight = weight;
        }

        public string FamilyName { get; set; }
        public double Size { get; set; }
        public FontStretch Stretch { get; set; }
        public FontStyle Style { get; set; }
        public FontWeight Weight { get; set; }
    }
}
