﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace Renderer2D.Core
{
    public interface IEllipse
    {
        IPoint Center { get; set; }
        double RadiusX { get; set; }
        double RadiusY { get; set; }
    }

    public class Ellipse : IEllipse
    {
        public Ellipse()
        {
        }

        public Ellipse(double centerX, double centerY, double radiusX, double radiusY)
            : this(new Point(centerX, centerY), radiusX, radiusY)
        {
        }

        public Ellipse(IPoint center, double radiusX, double radiusY)
        {
            if (center == null)
                throw new ArgumentNullException("center");

            Center = center;
            RadiusX = radiusX;
            RadiusY = radiusY;
        }

        public IPoint Center { get; set; }
        public double RadiusX { get; set; }
        public double RadiusY { get; set; }
    }
}
