﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace Renderer2D.Core.WinForms
{
    public sealed class WinFormsRenderContext : RenderContext
    {
        public Control RenderControl { get; private set; }
        public Graphics RenderGraphics { get; private set; }

        public WinFormsRenderContext(Control renderControl)
        {
            if (renderControl == null)
                throw new ArgumentNullException("renderControl");

            RenderControl = renderControl;
        }

        public void UpdateGraphics(Graphics graphics)
        {
            if (graphics == null)
                throw new ArgumentNullException("graphics");

            RenderGraphics = graphics;
        }

        public void UpdateViewportSize(ISize viewportSize)
        {
            if (viewportSize == null)
                throw new ArgumentNullException("viewportSize");

            ViewportSize = viewportSize;
        }
    }
}
