﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using System.Windows.Forms;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    class SessionInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Session"; } }

        public ContextInformation GetInformation()
        {
            var sessionInfo = new ContextInformationContainer();

            sessionInfo.Add("Boot mode", new StringContextInformation(SystemInformation.BootMode.ToString()));

            sessionInfo.Add("User name", new StringContextInformation(SystemInformation.UserName));
            sessionInfo.Add("Computer NETBIOS name", new StringContextInformation(SystemInformation.ComputerName));
            try { sessionInfo.Add("User domain", new StringContextInformation(SystemInformation.UserDomainName)); }
            catch (Win32Exception) { sessionInfo.Add("User domain", new StringContextInformation("Not supported")); }

            sessionInfo.Add("User-interactive mode", new DecimalContextInformation(SystemInformation.UserInteractive ? 1 : 0));
            sessionInfo.Add("Terminal Services client session", new DecimalContextInformation(SystemInformation.TerminalServerSession ? 1 : 0));

            return sessionInfo;
        }
    }
}
