﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

using EnvironmentReporting;

namespace EnvironmentInformationProvider
{
    public class DrivesInformationProvider : IInformationProvider
    {
        public string InformationDescription { get { return "Drives"; } }

        public ContextInformation GetInformation()
        {
            var drivesInfo = new ContextInformationContainer();

            int i = 0;
            foreach (var drive in DriveInfo.GetDrives())
            {
                var driveInfo = new ContextInformationContainer();

                driveInfo.Add("Type", new StringContextInformation(drive.DriveType.ToString()));
                driveInfo.Add("IsReady", new DecimalContextInformation(drive.IsReady ? 1 : 0));
                if (drive.IsReady)
                {
                    driveInfo.Add("Format", new StringContextInformation(drive.DriveFormat));
                    driveInfo.Add("Total size", new DecimalContextInformation(drive.TotalSize));
                    driveInfo.Add("Available free space", new DecimalContextInformation(drive.AvailableFreeSpace));
                    driveInfo.Add("Total free space", new DecimalContextInformation(drive.TotalFreeSpace));
                }

                drivesInfo.Add(i.ToString(), driveInfo);
                ++i;
            }

            return drivesInfo;
        }
    }
}
