﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectDefinitions
{
    /// <summary>
    /// Plug, with source of all its elements.
    /// </summary>
    public class PlugWithSource : Plug
    {
        public PlugWithSource(DefinitionLocation source,
            DefinitionLocation nameSource, string name,
            DefinitionLocation typeSource, ShaderTypeDefinition type,
            DefinitionLocation targetSource, string target,
            DefinitionLocation semanticSource, string semantic,
            DefinitionLocation defaultValuesSource, string[] defaultValues,
            bool isInput)
            : base(name, type, target, isInput, semantic, defaultValues)
        {
            Source = source;
            NameSource = nameSource;
            TypeSource = typeSource;
            TargetSource = targetSource;
            SemanticSource = semanticSource;
            DefaultValuesSource = defaultValuesSource;
        }

        public DefinitionLocation Source { get; private set; }
        public DefinitionLocation NameSource { get; private set; }
        public DefinitionLocation TypeSource { get; private set; }
        public DefinitionLocation TargetSource { get; private set; }
        public DefinitionLocation SemanticSource { get; private set; }
        public DefinitionLocation DefaultValuesSource { get; private set; }
    }
}
