﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace EffectDefinitions
{
    /// <summary>
    /// Definition of a shader language function, with sources of all its elements.
    /// </summary>
    public class FunctionDefinitionWithSource : FunctionDefinition
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="definition">関数の定義情報</param>
        public FunctionDefinitionWithSource(FunctionDefinition definition)
            : base(
            definition.Source,
            definition.Id,
            definition.Name,
            (ShaderTypeDefinition)definition.ReturnType,
            definition.ReturnUsage,
            definition.ReturnDescription,
            definition.Description,
            definition.Parameters.Cast<ParameterDefinition>().ToArray())
        {
            this.IdSource = null;
            this.NameSource = null;
            this.ReturnTypeSource = null;
            this.ReturnUsageSource = null;
            this.ReturnDescriptionSource = null;
            this.DescriptionSource = null;
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">glslファイルのソース情報</param>
        /// <param name="idSource">glslファイルの識別子情報</param>
        /// <param name="id">識別子</param>
        /// <param name="nameSource">glslファイルの名前情報</param>
        /// <param name="name">名前</param>
        /// <param name="returnTypeSource">glslファイルの返却値情報</param>
        /// <param name="returnType">返却値</param>
        /// <param name="returnDescriptionSource">glslファイルの返却値説明情報</param>
        /// <param name="returnDescription">説明</param>
        /// <param name="usageSource">glslファイルの関数使用方法</param>
        /// <param name="usage">関数使用方法</param>
        /// <param name="descriptionSource">glslファイルの説明情報</param>
        /// <param name="description">説明</param>
        /// <param name="parameters">関数情報</param>
        public FunctionDefinitionWithSource(
            DefinitionLocation source,
            DefinitionLocation idSource,
            string id,
            DefinitionLocation nameSource,
            string name,
            DefinitionLocation returnTypeSource,
            ShaderTypeDefinition returnType,
            DefinitionLocation returnDescriptionSource,
            string returnDescription,
            DefinitionLocation usageSource,
            string usage,
            DefinitionLocation descriptionSource,
            string description,
            params ParameterDefinition[] parameters)
            : base(source, id, name, returnType, usage, returnDescription, description, parameters)
        {
            this.IdSource = idSource;
            this.NameSource = nameSource;
            this.ReturnTypeSource = returnTypeSource;
            this.ReturnUsageSource = usageSource;
            this.ReturnDescriptionSource = returnDescriptionSource;
            this.DescriptionSource = descriptionSource;
        }

        /// <summary>
        /// glslファイルの識別子情報です。
        /// </summary>
        public DefinitionLocation IdSource { get; internal set; }

        /// <summary>
        /// glslファイルの名前情報です。
        /// </summary>
        public DefinitionLocation NameSource { get; internal set; }

        /// <summary>
        /// glslファイルの返却値情報です。
        /// </summary>
        public DefinitionLocation ReturnTypeSource { get; internal set; }

        /// <summary>
        /// glslファイルの返却値説明情報です。
        /// </summary>
        public DefinitionLocation ReturnDescriptionSource { get; internal set; }

        /// <summary>
        /// glslファイルの説明情報です。
        /// </summary>
        public DefinitionLocation ReturnUsageSource { get; internal set; }

        /// <summary>
        /// glslファイルの説明情報です。
        /// </summary>
        public DefinitionLocation DescriptionSource { get; internal set; }
    }
}
