﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using EffectCombiner.Primitives.Generation;
using Microsoft.VisualStudio.TestTools.UnitTesting;


namespace EffectCombinerUnitTests
{
    [TestClass]
    public class EffectWorkflowItemTest
    {
        #region EffectInputPlug

        [TestMethod]
        public void EffectInputPlugValidConstructorTest()
        {
            var inputPlug = Utility.CreateInputPlug("foo", "float");
            var blockElement = Utility.CreateDummyInputBlock(inputPlug);

            var plug = new EffectInputPlug(inputPlug, blockElement);
            if (plug == null)
                throw new Exception("EffectInputPlug was excpected to succeed.");
        }

        [TestMethod]
        public void EffectInputPlugInvalidConstructorTest()
        {
            var outputPlug = Utility.CreateOutputPlug("foo", "float");
            var blockElement = Utility.CreateDummyOutputBlock(outputPlug);

            EffectInputPlug plug = null;
            try
            {
                plug = new EffectInputPlug(outputPlug, blockElement);
            }
            catch
            {
                return;
            }
            if (plug != null)
                throw new Exception("EffectInputPlug was expected to fail.");
        }

        #endregion

        #region EffectOutputPlug

        [TestMethod]
        public void EffectOutputPlugValidConstructorTest()
        {
            var outputPlug = Utility.CreateOutputPlug("foo", "float");
            var blockElement = Utility.CreateDummyOutputBlock(outputPlug);

            var plug = new EffectOutputPlug(outputPlug, blockElement);
            if (plug == null)
                throw new Exception("EffectOutputPlug was excpected to succeed.");
        }

        [TestMethod]
        public void EffectOutputPlugInvalidConstructorTest()
        {
            var inputPlug = Utility.CreateInputPlug("foo", "float");
            var blockElement = Utility.CreateDummyInputBlock(inputPlug);

            EffectOutputPlug plug = null;

            try
            {
                plug = new EffectOutputPlug(inputPlug, blockElement);
            }
            catch
            {
                return;
            }
            if (plug != null)
                throw new Exception("EffectOutputPlug was expected to fail.");
        }

        #endregion
    }
}
