﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using ShaderGenerator.Core;
using EffectDefinitions;
using EffectCombiner.Core;

namespace EffectCombiner.Primitives.Generation
{
    public class ResourceLocator : IResourceLocator
    {
        private readonly IEnumerable<FunctionDefinition> functions;

        public ResourceLocator(IEnumerable<FunctionDefinition> functions)
        {
            if (functions == null)
                throw new ArgumentNullException("functions");

            this.functions = functions;
        }

        public Uri GetResourceLocation(string identifier)
        {
            var func = functions.FirstOrDefault(fd => fd.GetMangling() == identifier);

            if (func == null)
                throw new Exception(string.Format(Messages.EXCEPTION_UNEXPECTED_ERROR_WHILE_RETRIEVING, identifier));

            if (func.Source != null)
                return func.Source.Uri;

            return new Uri(string.Format("autogen://{0}", identifier));
        }
    }
}
