﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation
{
    public static class Globals
    {
        public static readonly string PolymorphicTypeString = "*";
        public static readonly ShaderTyping.ShaderTypeDefinition PolymorphicType = new ShaderTypeDefinition(PolymorphicTypeString);

        public static IDictionary<string, BlockDefinition> BlockDefinitions { get; private set; }

        /// <summary>
        /// Uniformマネージャです。
        /// </summary>
        private static UniformManager uniformManager = new UniformManager();

        /// <summary>
        /// Uniformマネージャを取得します。
        /// </summary>
        public static UniformManager UniformManager
        {
            get
            {
                return uniformManager;
            }
        }

        public static void SetBlockDefinitions(IEnumerable<BlockDefinition> blockDefinitions)
        {
            if (blockDefinitions == null)
                throw new ArgumentNullException("blockDefinitions");
            BlockDefinitions = blockDefinitions.ToDictionary(b => b.Guid);
        }
    }
}
