﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation
{
    public class CommentFunctionDefinition : FunctionDefinition
    {
        public CommentFunctionDefinition()
            : base(null, "comment", "comment", new ShaderTypeDefinition("float"), null, null, null)
        {
        }
    }

    public class CommentBlockDefinition : BlockDefinition
    {
        // コメントブロックにつけるタグ名
        private static readonly string[] tags = {"Comment"};

        public static readonly string CommentBlockDefinitionGuid = "{5CA49B9D-571C-4B1D-9D87-F63EC535FE60}";

        public CommentFunctionDefinition FunctionDefinition { get; private set; }

        public CommentBlockDefinition()
            : base(
            null,
            "Comment",
            CommentBlockDefinitionGuid,
            string.Empty,
            new Plug[0],
            new Plug[0],
            null,
            new PreviewDefinition(),
            new FunctionBinding(null, null, "comment", null, "comment"))
        {
            FunctionDefinition = new CommentFunctionDefinition();
            BindToFunctionDefinition(FunctionDefinition);

            Text = "Comment";
            // TODO: update block name at runtime
        }

        /// <summary>
        /// Tags of the active function definition.
        /// </summary>
        public override IEnumerable<string> Tags
        {
            get
            {
                return IsBound ? tags : Enumerable.Empty<string>();
            }
        }

        public string Text { get; set; }
    }
}
