﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Blocks.Core;
using EffectCombiner.Primitives.Generation.AutoGen;
using EffectCombiner.Primitives.Generation.Semantic;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation
{
    public class BlockElementGenerator : IBlockElementGenerator
    {
        public BlockElementBase CreateBlockElement(BlockDefinition blockDefinition)
        {
            if (blockDefinition is PolymorphicBlockDefinition)
                return new PolymorphicBlockElement(blockDefinition);
            if (blockDefinition is ConstantBlockDefinition)
                return new ConstantBlockElement();
            if (blockDefinition is CommentBlockDefinition)
                return new CommentBlockElement();
            if (blockDefinition is GhostBlockDefinition)
                return new GhostBlockElement(blockDefinition);
            if (blockDefinition is UserDefinition)
                return new UserDefinitionBlockElement((UserDefinition)blockDefinition);
            if (blockDefinition is BlockDefinitionWithSource)
                return new UserDefinitionBlockElement(new UserDefinition(blockDefinition));

            return new RegularEffectBlockElement(new EffectBlockDefinition(blockDefinition));
        }
    }
}
