﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectDefinitions;

namespace EffectCombiner.Primitives.Generation.AutoGen.Operators
{
    public class MixOperatorDefinitionSet : BuiltInFunctionDefinitionSet
    {
        public MixOperatorDefinitionSet()
            : base(
            "mix",
            "Mix",
            "{BF6F8F08-0A8E-4CFF-BCBD-7C5DC3A828F8}",
            new[] { "x", "y", "a" },
            new[]
            {
                new[] { "float", "float", "float", "float" },
                new[] { "vec2", "vec2", "vec2", "vec2" },
                new[] { "vec3", "vec3", "vec3", "vec3" },
                new[] { "vec4", "vec4", "vec4", "vec4" },
                new[] { "vec2", "vec2", "vec2", "float" },
                new[] { "vec3", "vec3", "vec3", "float" },
                new[] { "vec4", "vec4", "vec4", "float" },
                new[] { "double", "double", "double", "double" },
                new[] { "dvec2", "dvec2", "dvec2", "dvec2" },
                new[] { "dvec3", "dvec3", "dvec3", "dvec3" },
                new[] { "dvec4", "dvec4", "dvec4", "dvec4" },
                new[] { "dvec2", "dvec2", "dvec2", "double" },
                new[] { "dvec3", "dvec3", "dvec3", "double" },
                new[] { "dvec4", "dvec4", "dvec4", "double" },
            })
        {
        }
    }
}
