﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectCombiner.Generator;
using System.IO;

namespace Tester
{
    class Program
    {
        static void Main(string[] args)
        {
            var settings = new ShaderGenSettings();

            //settings.ErrorReporter

            var dataPath = AppDomain.CurrentDomain.BaseDirectory + @"\..\..\..\..\..\";

            string[] paths =
            {
                @"TestData\UnitTests\InOutBlocks",
                @"TestData\EftDefinitions",
                //@"TestData\Real case",
                @"TestData\UnitTests\Semantic",
            };

            foreach (var path in paths)
            {
                settings.EffectDefinitionsPaths.Add(
                    string.Format("{0}\\{1}", dataPath, path),
                    SearchOption.AllDirectories, "*.glsl", "*.edml");
            }

            var shaderGenerator = new ShaderGen(settings);
            shaderGenerator.Initialize();

            //const string file = @"TestData\Real case\test_ticket_2310.xml";

            //const string file = @"TestData\Real case\test3.xml";
            //const string file = @"TestData\Real case\SphereMapTest.xml";

            //const string file = @"TestData\Real case\mix2.xml";
            //const string file = @"TestData\Real case\albedo-and-diffuse.xml";
            //const string file = @"TestData\Real case\test_joker_block2.xml";
            //const string file = @"TestData\test_semantic_03.xml";
            const string file = @"TestData\test_semantic_layout.xml";

            var filename = Path.GetFullPath(string.Format("{0}\\{1}", dataPath, file));

            var codes = shaderGenerator.ProduceShaderCodes(filename);

            if (codes == null || codes.Length == 0)
            {
                Console.WriteLine("No code produced.");
            }
            else if (codes.Length == 1)
            {
                Console.WriteLine(codes[0]);
            }
            else
            {
                Console.WriteLine("There are {0} codes produced.", codes.Length);

                var i = 0;
                foreach (var code in codes)
                {
                    Console.WriteLine("Code {0}:", i + 1);
                    Console.WriteLine(code);
                    Console.WriteLine(new string('-', 60));
                    Console.WriteLine();
                    if (i < codes.Length - 1)
                    {
                        Console.WriteLine("Press any key to display next code.");
                        Console.ReadKey(true);
                    }
                    i++;
                }
            }

            Console.WriteLine("Press any key to exit...");
            Console.ReadKey(true);
        }
    }
}
