﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using EffectCombiner.Editor.Properties;

namespace EffectCombiner.Editor.Controls
{
    public partial class TagControl : UserControl
    {
        public TagControl()
        {
            InitializeComponent();

            LightBorderColor = Color.Gainsboro;
            DarkBorderColor = Color.DarkGray;

            picRemove.Image = Resources.remove_norm;

            picRemove.Click += PictureRemoveClick;
            picRemove.MouseEnter += PictureRemoveMouseEnter;
            picRemove.MouseLeave += PictureRemoveMouseLeave;
        }

        private readonly Action removeAction;

        private const int ControlMargin = 1;
        private const int RemoveButtonMargin = 2;

        public Control Content { get; private set; }

        public TagControl(Control content, Action remove)
            : this()
        {
            if (remove == null)
                throw new ArgumentNullException("remove");

            removeAction = remove;

            if (content == null)
                return;

            Content = content;

            Width = content.Width + picRemove.Width + RemoveButtonMargin * 2 + ControlMargin * 2;
            Height = Math.Max(content.Height, picRemove.Height) + ControlMargin * 2;

            content.Left = ControlMargin;
            content.Top = (Height - content.Height) / 2;

            picRemove.Left = content.Width + RemoveButtonMargin;
            picRemove.Top = (Height - picRemove.Height) / 2;

            Controls.Add(content);
        }

        private void PictureRemoveClick(object sender, EventArgs e)
        {
            removeAction();
        }

        private void PictureRemoveMouseEnter(object sender, EventArgs e)
        {
            picRemove.Image = Resources.remove_over;
        }

        private void PictureRemoveMouseLeave(object sender, EventArgs e)
        {
            picRemove.Image = Resources.remove_norm;
        }

        private Pen lightBorderPen;
        private Color lightBorderColor;
        public Color LightBorderColor
        {
            get { return lightBorderColor; }
            set
            {
                if (lightBorderPen != null)
                    lightBorderPen.Dispose();
                lightBorderColor = value;
                lightBorderPen = new Pen(lightBorderColor, 1.0f);
            }
        }

        private Pen darkBorderPen;
        private Color darkBorderColor;
        public Color DarkBorderColor
        {
            get { return darkBorderColor; }
            set
            {
                if (darkBorderPen != null)
                    darkBorderPen.Dispose();
                darkBorderColor = value;
                darkBorderPen = new Pen(darkBorderColor, 1.0f);
            }
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            if (lightBorderPen == null || darkBorderPen == null)
                return;

            e.Graphics.DrawLine(lightBorderPen, 0, 0, Width, 0);
            e.Graphics.DrawLine(lightBorderPen, 0, 0, 0, Height);

            e.Graphics.DrawLine(darkBorderPen, Width - 1, 0, Width - 1, Height);
            e.Graphics.DrawLine(darkBorderPen, 0, Height - 1, Width, Height - 1);
        }
    }
}
