﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Communication.Core;
using Communication.Contracts;
using System.ServiceModel;
using System.Threading.Tasks;
using EffectCombiner.Core;
using EffectCombiner.Primitives;

namespace EffectCombiner.Editor
{
    public class CommunicationManager
    {
        public void SendShaderCodeAsync(string filePath, string code, bool showForm)
        {
            Task.Factory.StartNew(() => SendShaderCode(filePath, code, showForm));
        }

        public void SendShaderCode(string filePath, string code, bool showForm)
        {
            var service = CommunicationClient.CreateProxy<IShaderTransferService>();

            try
            {
                var result = service.Transfer(filePath, code);

                if (result == ShaderTransferResult.EmitterNotFound)
                {
                    Reporting.Report(new EventReport(
                        () => Localization.Messages.REMOTE_EMITTER_NOT_FOUND,
                        ReportLevel.Warning,
                        ReportCategory.Communication,
                        null,
                        null,
                        null
                        ));
                }
                else
                {
                    Globals.QuickInfo.SetQuickInfo(string.Empty, true);
                }
            }
            catch (EndpointNotFoundException)
            {
                Reporting.Report(new EventReport(
                    () => Localization.Messages.REMOTE_SHADER_TRANSFER_SERVICE_NOT_FOUND,
                    ReportLevel.Warning,
                    ReportCategory.Communication,
                    null,
                    null,
                    null
                ), showForm);
            }
        }

        public void CloseConnection()
        {
            var service = CommunicationClient.CreateProxy<IShaderTransferService>();

            try
            {
                service.OnConnectionClosed();
            }
            catch (EndpointNotFoundException)
            {
                // Ignore the exception, since there is no end point then
                // it doesn't matter if the connection is closed or not.
            }
        }
    }
}
