﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Renderer2D.Core;
using EffectDefinitions;
using EffectCombiner.Editor.Controls;

namespace EffectCombiner.Editor
{
    public partial class BlockPreviewForm : Form
    {
        public BlockPreviewForm()
        {
            InitializeComponent();
        }

        private BlockPreviewRenderSurface surface;

        public bool IsSurfaceReady
        {
            get
            {
                return surface != null && surface.BlockDefinition != null;
            }
        }

        protected override bool ShowWithoutActivation
        {
            get
            {
                return true;
            }
        }

        public void SetRenderer(Renderer renderer)
        {
            if (surface != null)
                surface.Dispose();

            pnlRender.Controls.Clear();

            surface = new BlockPreviewRenderSurface(this)
            {
                Dock = DockStyle.Fill,
            };
            surface.SetRenderer(renderer);
            pnlRender.Controls.Add(surface);
        }

        public void SetBlockDefinition(BlockDefinition blockDefinition)
        {
            if (surface != null)
                surface.BlockDefinition = blockDefinition;
        }
    }
}
