﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectCombiner.Data.Processors.Version1;
using EffectCombiner.Data.Processors.Version2;

namespace EffectCombiner.Data.Converters
{
    public class WorkflowConverterV1V2 : IWorkflowConverter
    {
        public ushort SourceVersion
        {
            get { return 1; }
        }

        public ushort TargetVersion
        {
            get { return 2; }
        }

        public object Convert(object sourceWorkflowData)
        {
            var project = (ProjectV1)sourceWorkflowData;

            var projectV2 = new ProjectV2
            {
                Version = 2,
                WorkspacePositionX = project.WorkspacePositionX,
                WorkspacePositionY = project.WorkspacePositionY,
                Blocks = new BlocksV2(),
                Connections = new ConnectionsV2(),
                Uniforms = new UniformsV2()
            };

            if (project.Blocks.Block != null)
                projectV2.Blocks.Block = project.Blocks.Block.Select(Convert).ToArray();

            if (project.Connections.Connection != null)
                projectV2.Connections.Connection = project.Connections.Connection.Select(Convert).ToArray();

            return projectV2;
        }

        private static BlockV2 Convert(BlockV1 block)
        {
            return new BlockV2
            {
                BlockGuid = block.BlockGuid,
                Identifier = block.Identifier,
                PositionX = block.PositionX,
                PositionY = block.PositionY,
            };
        }

        private static ConnectionV2 Convert(ConnectionV1 connection)
        {
            return new ConnectionV2
            {
                Source = new BlockReferenceV2
                {
                    BlockIdentifier = connection.Source.BlockIdentifier,
                    PlugIndex = connection.Source.PlugIndex,
                },
                Target = new BlockReferenceV2
                {
                    BlockIdentifier = connection.Target.BlockIdentifier,
                    PlugIndex = connection.Target.PlugIndex,
                },
            };
        }
    }

    public class WorkflowConverterV2V1 : IWorkflowConverter
    {
        public ushort SourceVersion
        {
            get { return 2; }
        }

        public ushort TargetVersion
        {
            get { return 1; }
        }

        public object Convert(object sourceWorkflowData)
        {
            var project = (ProjectV2)sourceWorkflowData;

            var projectV1 = new ProjectV1
            {
                Version = 2,
                WorkspacePositionX = project.WorkspacePositionX,
                WorkspacePositionY = project.WorkspacePositionY,
                Blocks = new BlocksV1(),
                Connections = new ConnectionsV1(),
            };

            if (project.Blocks.Block != null)
                projectV1.Blocks.Block = project.Blocks.Block.Select(Convert).ToArray();

            if (project.Connections.Connection != null)
                projectV1.Connections.Connection = project.Connections.Connection.Select(Convert).ToArray();

            return projectV1;
        }

        private static BlockV1 Convert(BlockV2 block)
        {
            return new BlockV1
            {
                BlockGuid = block.BlockGuid,
                Identifier = block.Identifier,
                PositionX = block.PositionX,
                PositionY = block.PositionY,
            };
        }

        private static ConnectionV1 Convert(ConnectionV2 connection)
        {
            return new ConnectionV1
            {
                Source = new BlockReferenceV1
                {
                    BlockIdentifier = connection.Source.BlockIdentifier,
                    PlugIndex = connection.Source.PlugIndex,
                },
                Target = new BlockReferenceV1
                {
                    BlockIdentifier = connection.Target.BlockIdentifier,
                    PlugIndex = connection.Target.PlugIndex,
                },
            };
        }
    }
}
