﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using EffectCombiner.Primitives.Extensions;
using EffectDefinitions;
using Renderer2D.Core;
using Renderer2D.Core.WinForms;
using EffectCombiner.Primitives.Blocks.BlockRenderers;

namespace EffectCombiner.BlockAssistant
{
    public class RenderSurface : RenderControl
    {
        private readonly BlockRendererBase blockRenderer = new RegularBlockRenderer();

        private readonly object syncRoot = new object();
        private ISize blockSize;

        private BlockDefinition blockDefinition;
        public BlockDefinition BlockDefinition
        {
            get
            {
                lock (syncRoot)
                    return blockDefinition;
            }
            set
            {
                lock (syncRoot)
                {
                    blockDefinition = value;
                    if (blockDefinition == null)
                        return;

                    blockRenderer.Initialize(blockDefinition);
                    blockSize = blockRenderer.Measure(Renderer, blockDefinition);
                }

                IPoint[] inputs;
                IPoint[] outputs;

                blockDefinition.GetPlugPositions(blockSize, out inputs, out outputs);
                blockRenderer.InputPlugPositions = inputs;
                blockRenderer.OutputPlugPositions = outputs;

                ClientSize = new System.Drawing.Size((int)blockSize.Width + 16, (int)blockSize.Height + 16);
            }
        }

        protected override void OnRender()
        {
            Renderer.Clear(BackColor.ToRendererColor());

            BlockDefinition localBlockDefinition;
            lock (syncRoot)
                localBlockDefinition = blockDefinition;

            var originalMatrix = Renderer.Transform ?? Matrix.Identity;
            Renderer.Transform = Matrix.Identity;

            if (localBlockDefinition != null && blockSize != null)
                blockRenderer.Render(Renderer, localBlockDefinition, new Rectangle(new Point(7.0, 7.0), blockSize));

            Renderer.Transform = originalMatrix;
        }
    }
}
