/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

//=============================================================================
// include
//=============================================================================
#ifdef __POWERPC__
    #if TARGET_CARBON
        #include "PIRezMacCarbon.h"
    #else
        #include "PIRezMac.h"
    #endif
    #define PRAGMA_ONCE 0
#else
    #define Rez 1
#endif

#include "PIDefines.h"
#include "PIActions.h"

#include "NintendoNormalMapFilterScripting.h"

#ifdef __PIWin__
    #include "PIGeneral.h"
    #include "PIUtilities.r"
#elif defined(__PIMac__)
    #include "Types.r"
    #include "SysTypes.r"
    #include "PIGeneral.r"
    #include "PIUtilities.r"
#endif

//=============================================================================
// PiPL resource
//=============================================================================
resource 'PiPL' (ResourceID, plugInName " PiPL", purgeable)
{
    {
        Kind { Filter },
        Name { plugInName "..." },
        Category { vendorName },
        Version { (latestFilterVersion << 16 ) | latestFilterSubVersion },

        #ifdef __PIWin__
            #if defined(_WIN64)
                CodeWin64X86 { "PluginMain" },
            #else
                CodeWin32X86 { "PluginMain" },
            #endif
        #elif TARGET_CARBON
            CodeCarbonPowerPC { 0, 0, "" },
        #else
            CodePowerPC { 0, 0, "" },
        #endif

        // ClassID, eventID, aete ID, uniqueString:
        HasTerminology { plugInClassID, plugInEventID, ResourceID, plugInUniqueID },

        SupportedModes
        {
            noBitmap,
            doesSupportGrayScale,
            noIndexedColor,
            doesSupportRGBColor,
            noCMYKColor,
            noHSLColor,
            noHSBColor,
            noMultichannel,
            noDuotone,
            noLABColor
        },
        EnableInfo { "in (PSHOP_ImageMode, GrayScaleMode, RGBMode)" },

        FilterCaseInfo
        {
            {
                /* Flat data, no selection */
                inStraightData, outStraightData,
                doNotWriteOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Flat data with selection */
                inStraightData, outStraightData,
                //doNotWriteOutsideSelection, // autoMask L
                writeOutsideSelection, // autoMask 
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Floating selection */
                inStraightData, outStraightData,
                writeOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Editable transparency, no selection */
                inStraightData, outStraightData,
                doNotWriteOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Editable transparency, with selection */
                inStraightData, outStraightData,
                writeOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Preserved transparency, no selection */
                inStraightData, outStraightData,
                doNotWriteOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination,

                /* Preserved transparency, with selection */
                inStraightData, outStraightData,
                writeOutsideSelection,
                filtersLayerMasks, worksWithBlankData,
                copySourceToDestination
            }
        }
    }
};

//=============================================================================
// dictionary (scripting) resource
//=============================================================================
resource 'aete' (ResourceID, plugInName " dictionary", purgeable)
{
    1, 0, english, roman,                                   /* aete version and language specifiers */
    {
        vendorName,                                         /* vendor suite name */
        "Normal Map Filter",                                /* optional description */
        plugInSuiteID,                                      /* suite ID */
        1,                                                  /* suite code, must be 1 */
        1,                                                  /* suite level, must be 1 */
        {                                                   /* structure for filters */
            plugInName,                                     /* unique filter name */
            plugInAETEComment,                              /* optional description */
            plugInClassID,                                  /* class ID, must be unique or Suite ID */
            plugInEventID,                                  /* event ID, must be unique to class ID */

            NO_REPLY,                                       /* never a reply */
            IMAGE_DIRECT_PARAMETER,                         /* direct parameter, used by Photoshop */
            {                                               /* parameters here, if any */
                "Operation",                                /* parameter name */
                nnNormalMapFilterKeyOperation,              /* parameter key ID */
                nnNormalMapFilterTypeOperation,             /* parameter type ID */
                "operation",                                /* optional description */
                flagsEnumeratedParameter,                   /* parameter flags */

                "Positive Z",                               /* parameter name */
                nnNormalMapFilterKeyPositiveZ,              /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "positive z",                               /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Height Scale",                             /* parameter name */
                nnNormalMapFilterKeyHeightScale,            /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "height scale",                             /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "FilterType",                               /* parameter name */
                nnNormalMapFilterKeyFilterType,             /* parameter key ID */
                nnNormalMapFilterTypeFilterType,            /* parameter type ID */
                "filtertype",                               /* optional description */
                flagsOptionalEnumeratedParameter,           /* parameter flags */

                "Edge Wrap",                                /* parameter name */
                nnNormalMapFilterKeyEdgeWrap,               /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "edge wrap",                                /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Multiply Alpha",                           /* parameter name */
                nnNormalMapFilterKeyMultiplyAlpha,          /* parameter key ID */
                typeBoolean,                                /* parameter type ID */
                "multiply alpha",                           /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Slope Scale",                              /* parameter name */
                nnNormalMapFilterKeySlopeScale,             /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "slope scale",                              /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Other Path",                               /* parameter name */
                nnNormalMapFilterKeyOtherPath,              /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "other path",                               /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Combine Scale",                            /* parameter name */
                nnNormalMapFilterKeyCombineScale,           /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "combine scale",                            /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Layer 0",                                  /* parameter name */
                nnNormalMapFilterKeyLayerName0,             /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "layer 0",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Layer 1",                                  /* parameter name */
                nnNormalMapFilterKeyLayerName1,             /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "layer 1",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Layer 2",                                  /* parameter name */
                nnNormalMapFilterKeyLayerName2,             /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "layer 2",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Layer 3",                                  /* parameter name */
                nnNormalMapFilterKeyLayerName3,             /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "layer 3",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Layer 4",                                  /* parameter name */
                nnNormalMapFilterKeyLayerName4,             /* parameter key ID */
                typeChar,                                   /* parameter type ID */
                "layer 4",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Scale 1",                                  /* parameter name */
                nnNormalMapFilterKeyLayerScale1,            /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "scale 1",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Scale 2",                                  /* parameter name */
                nnNormalMapFilterKeyLayerScale2,            /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "scale 2",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Scale 3",                                  /* parameter name */
                nnNormalMapFilterKeyLayerScale3,            /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "scale 3",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */

                "Scale 4",                                  /* parameter name */
                nnNormalMapFilterKeyLayerScale4,            /* parameter key ID */
                typeInteger,                                /* parameter type ID */
                "scale 4",                                  /* optional description */
                flagsOptionalSingleParameter,               /* parameter flags */
            }
        },
        {                                                   /* non-filter plug-in class here */
        },
        {                                                   /* comparison ops (not supported) */
        },
        {                                                   /* any enumerations */
            nnNormalMapFilterTypeFilterType,
            {
                "4",
                nnNormalMapFilterEnumFilterType4,
                "4",

                "3x3",
                nnNormalMapFilterEnumFilterType3x3,
                "3x3",

                "5x5",
                nnNormalMapFilterEnumFilterType5x5,
                "5x5",

                "7x7",
                nnNormalMapFilterEnumFilterType7x7,
                "7x7",

                "9x9",
                nnNormalMapFilterEnumFilterType9x9,
                "9x9",

                "13x13",
                nnNormalMapFilterEnumFilterType13x13,
                "13x13",

                "17x17",
                nnNormalMapFilterEnumFilterType17x17,
                "17x17",

                "21x21",
                nnNormalMapFilterEnumFilterType21x21,
                "21x21",

                "25x25",
                nnNormalMapFilterEnumFilterType25x25,
                "25x25",
            },
            nnNormalMapFilterTypeOperation,
            {
                "Convert from Height Map",
                nnNormalMapFilterEnumConvertFromHeightMap,
                "Convert from Height Map",

                "Normalize",
                nnNormalMapFilterEnumNormalize,
                "Normalize",

                "Scale Slope",
                nnNormalMapFilterEnumScaleSlope,
                "Scale Slope",

                "Combine",
                nnNormalMapFilterEnumCombineFile,
                "Combine",

                "Combine Layer",
                nnNormalMapFilterEnumCombineLayer,
                "Combine Layer",
            },
        }
    }
};

