﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

//=============================================================================
// constants
//=============================================================================
#define NPS_PLUGIN_VERSION "4.5.0"
#define NPS_COPYRIGHT_MSG "Copyright (C)Nintendo All rights reserved."

#ifdef NDEBUG
    #define NPS_ABOUT_TITLE "About " NPS_PLUGIN_NAME
#else
    #define NPS_ABOUT_TITLE "About " NPS_PLUGIN_NAME " (Debug)"
#endif

#if (PS_API_VERSION >= 1500)
    #define NPS_SDK_VERSION "15.0"
#elif (PS_API_VERSION >= 1400)
    #define NPS_SDK_VERSION "14.0"
#elif (PS_API_VERSION >= 1300)
    #define NPS_SDK_VERSION "13.0"
#elif (PS_API_VERSION >= 1200)
    #define NPS_SDK_VERSION "12.0"
#elif (PS_API_VERSION >= 1100)
    #define NPS_SDK_VERSION "11.0"
#else
    #define NPS_SDK_VERSION PIVersion
#endif

#define NPS_ABOUT_MESSAGE \
"Nintendo " NPS_PLUGIN_DESCRIPTION " for Adobe Photoshop\n\n" \
"Ver " NPS_PLUGIN_VERSION "\n\n" \
NPS_COPYRIGHT_MSG \
"\n\n(Photoshop SDK Ver " NPS_SDK_VERSION ")"

