﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// Globals RParameters

//=============================================================================
// include
//=============================================================================
#include "../NintendoFtx/NpsCommon.h"

#ifdef _MSC_VER
    #pragma warning(push)
    #pragma warning(disable: 4121) // メンバのアライメントは過剰にパッキングされています。
#endif

#include "PIFilter.h"

#ifdef _MSC_VER
    #pragma warning(pop)
#endif

//=============================================================================
// constants
//=============================================================================

//-----------------------------------------------------------------------------
// plugin name & help
#define NPS_PLUGIN_NAME "NintendoDistanceField"
#define NPS_PLUGIN_DESCRIPTION "Distance Field Filter Plugin"
#define NPS_PLUGIN_HELP_URL "html/NW4F_DistanceField.html"

//=============================================================================
//! @brief パラメータのクラスです。
//=============================================================================
class RParameters
{
  public:
    static const int DISTANCE_MIN =   1; //!< 白黒境界からの最大距離の最小値です。
    static const int DISTANCE_MAX = 250; //!< 白黒境界からの最大距離の最大値です。

    int m_MaxDistance; //!< 白黒境界からの最大距離（ピクセル）です。

    //! @brief 画像が繰り返しているとして端のピクセルを処理するなら true です。
    //!        画像の端のピクセルを引き伸ばして処理するなら false です。
    bool m_EdgeWrap;

    bool m_Normalize; //!< 結果を [0,1] に正規化するなら true です。

  public:
    //! 同値であれば true を返します。
    bool operator==(const RParameters& rhs) const
    {
        return (
            m_MaxDistance == rhs.m_MaxDistance &&
            m_EdgeWrap    == rhs.m_EdgeWrap    &&
            m_Normalize   == rhs.m_Normalize);
    }

    //! 同値でなければ true を返します。
    bool operator!=(const RParameters& rhs) const
    {
        return !(*this == rhs);
    }
};

typedef RParameters* RParametersPtr;
typedef RParameters** RParametersHdl;

//=============================================================================
//! @brief グローバルデータのクラスです。
//=============================================================================
class Globals
{
  public:
    // filter common
    int16* result;                  // Must always be first in Globals.
    FilterRecord* filterParamBlock; // Must always be second in Globals.
    Boolean queryForParameters;

    // image info
    int m_LayerCount; //!< 表示されているレイヤー数です。

    // channel
    ReadChannelDesc* m_ColorChanTop; //!< カラーのリードチャンネル記述子の先頭です。
    ReadChannelDesc* m_AlphaChanTop; //!< アルファのリードチャンネル記述子の先頭です。
    ReadChannelDesc* m_TransChanTop; //!< 透明度のリードチャンネル記述子の先頭です。
    int m_ColorChanCount; //!< カラーのチャンネル数です。
    int m_AlphaChanCount; //!< アルファのチャンネル数です。
    int m_TransChanCount; //!< 透明度のチャンネル数です。
    int m_SelColorChanCount; //!< 選択されたカラーのチャンネル数です。
    int m_SelAlphaChanCount; //!< 選択されたアルファのチャンネル数です。
    int m_SelTransChanCount; //!< 選択された透明度のチャンネル数です。
    bool m_UsesAlphaChan; //!< アルファのチャンネルが選択されていれば true です。
    bool m_UsesTransChan; //!< 透明度のチャンネルが選択されていてアルファのチャンネルが非選択なら true です。
    bool m_FiltersAlpha; //!< アルファまたは透明度のチャンネルが選択されていれば true です。

    // buffer
    uint8_t* m_pSrcBitmapData; //!< フィルタ処理前のビットマップデータを格納するバッファです。
    uint8_t* m_pDstBitmapData; //!< フィルタ処理後のビットマップデータを格納するバッファです。
    uint8_t* m_pBinaryData; //!< R 成分を 2 値化した値を格納するバッファです。
    float* m_pDistanceData; //!< 白黒境界までの距離を格納するバッファです。

    // preview
    bool m_DisplaysPreview; //!< プレビューを表示するなら true です。
    bool m_IsPreviewFiltered; //!< プレビューでフィルタ処理済みなら true です。
    RParameters m_PreviewParams; //!< プレビューでフィルタ処理したパラメータです。
};

typedef Globals* GPtr;
typedef Globals** GHdl;
typedef void (*FProc)(GPtr globals);

// filter common
#define gResult (*(globals->result))       // SDK のマクロのため、かならず gResult という名前で定義します。
#define gStuff (globals->filterParamBlock) // SDK のマクロのため、かならず gStuff  という名前で定義します。
#define gDocInfo (gStuff->documentInfo)
#define gBigDoc (gStuff->bigDocumentData)
#define gParams ((RParametersPtr)*gStuff->parameters)
#define gQueryForParameters (globals->queryForParameters)

