﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "DccCommon.h"

/******************************************************************************
    begin name space utility
******************************************************************************/
namespace nn {
namespace gfx {
namespace tool {
namespace dcc {
namespace utility {


/*-----------------------------------------------------------------------*
  @brief 中間ファイルオプティマイザを呼び出すためのクラスです。
  　自動変数でインスタンスを作成し、必要な最適化の設定を行った後に
  Optimize() を呼び出します。

  　初期状態の設定は以下のようになっています。

 *-----------------------------------------------------------------------*/
class ROptimizer
{
public:
    //! コンストラクタです。
    ROptimizer();
    //! デストラクタです。
    ~ROptimizer();

    //! @brief 最適化を実行します。
    //! 引数で指定された中間ファイルに対して中間ファイルオプティマイザの最適化処理を実行します。
    //! 最適化されたファイルは元のファイルに上書きします。
    //!	引数 outFolderPath に指定するパスの区切り文字は'/'でなければいけません。
    //!
    //! @param[in] outFolderPath	中間ファイルが出力されているフォルダのパスを指定します。
    //!								このパスの区切り文字は'/'でなければいけません。
    //! @param[in] outFileName		拡張子を除いた中間ファイルのファイル名を指定します。
    //! @param[in] opt				エクスポートオプション
    bool Optimize(
        const std::string& outFolderPath,
        const nn::gfx::tool::dcc::RExpOpt&	opt );


public:
protected:
    //-----------------------------------------------------------------------------
    //! @brief 中間ファイルオプティマイザのアニメーション中間ファイルマージ引数を追加します。
    //!
    //! @param[in,out] cmd 中間ファイルオプティマイザのコマンドの文字列です。
    //! @param[in] opt Export オプションです。
    //! @param[in] fileType ファイルタイプです。
    //-----------------------------------------------------------------------------
    void Add3dOptimizerMergeAnimArg(std::string* pArgStr, const RExpOpt& opt, const RExpOpt::FileType fileType);

    //-----------------------------------------------------------------------------
    //! @brief 中間ファイルオプティマイザのボーン圧縮引数を追加します。
    //!
    //! @param[in] yopt Export オプションです。
    //!
    //! @param[in,out] cmd 中間ファイルオプティマイザのコマンドの文字列です。
    //-----------------------------------------------------------------------------
    void Add3dOptimizerCompressBoneArg(std::string* pArgStr, const RExpOpt& opt);

    //-----------------------------------------------------------------------------
    //! @brief 中間ファイルオプティマイザのプリミティブ最適化引数を追加します。
    //!
    //! @param[in,out] cmd 中間ファイルオプティマイザのコマンドの文字列です。
    //! @param[in] yopt エクスポートオプションです。
    //-----------------------------------------------------------------------------
    void Add3dOptimizerPrimitiveArg(std::string* pArgStr, const RExpOpt& opt);

    //-----------------------------------------------------------------------------
    //! @brief 中間ファイルオプティマイザの量子化分析引数を追加します。
    //!
    //! @param[in,out] cmd 中間ファイルオプティマイザのコマンドの文字列です。
    //! @param[in] opt エクスポートオプションです。
    //-----------------------------------------------------------------------------
    void Add3dOptimizerQuantizationAnalysisArg(std::string* pArgStr, const RExpOpt& opt);

    std::string Get3dOptimizerFmdArgs(const RExpOpt& yopt, const std::string tempPath);
    std::string Get3dOptimizerAnimArgs(const RExpOpt& yopt, const RExpOpt::FileType fileType, const std::string tempPath);
};





/******************************************************************************
    end name space utility
******************************************************************************/
}}}}} // namespace utility
