﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <util/types.h>

namespace nw { namespace g3d { namespace tool {

namespace util {

class XMLElement
{
public:
    operator bool() const;

    int AttributeIndex(const StringRef& id) const;
    const char* Attribute(const StringRef& id) const;
    const char* AttributeId(int index) const;
    const char* Text() const;

    XMLElement* Child(const StringRef& id);
    const XMLElement* Child(const StringRef& id) const;
    XMLElement* NextSibling();
    const XMLElement* NextSibling() const;

    XMLElement* NextSibling(const LiteralStr& id); // deprecated
    const XMLElement* NextSibling(const LiteralStr& id) const; // deprecated

private:
    XMLElement() : m_pImpl(nullptr) {}

    const void* m_pImpl;
};

class XMLParser
{
public:
    XMLParser();
    ~XMLParser();

    bool ParseTree(char* doc, size_t size);
    void Clear();

    XMLElement* Root();

private:
    void* m_pImpl;
};

template<typename T>
std::shared_ptr<T> AddElem(const util::XMLElement* pRoot, int checkFlag)
{
    std::shared_ptr<T> elem(new T());
    *elem << pRoot->Child(T::Id());
    elem->PostProcess();
    elem->CheckData(checkFlag);
    return elem;
}

template<typename T>
std::shared_ptr<T> AddBinaryElem(const util::XMLElement* pRoot, void* binaryOffset, int checkFlag)
{
    std::shared_ptr<T> elem(new T());
    *elem << pRoot->Child(T::Id());
    elem->PostBinaryProcess(binaryOffset);
    elem->CheckData(checkFlag);
    return elem;
}

template<typename T>
void AddPath(std::shared_ptr<T> elem, const char* fileName, const char* fullPath)
{
    elem->SetName(fileName);
    elem->SetPath(fullPath);
}

} // namespace util

} // namespace tool
} // namespace g3d
} // namespace nw
