﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/VisibilityAnim.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

void elem_mat_vis_mat_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        mat_name << pElem;
        base_value << pElem;

        curve.Validate();
        if (!curve->Read(pElem))
        {
            curve.Invalidate();
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_bone_vis_bone_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        bone_name << pElem;
        binarize_visibility << pElem;
        base_value << pElem;

        curve.Validate();
        if (!curve->Read(pElem))
        {
            curve.Invalidate();
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_mat_visibility_anim_info::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        frame_count << pElem;
        loop << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_bone_visibility_anim_info::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        frame_count << pElem;
        loop << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_mat_visibility_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        version << pElem;
        mat_visibility_anim_info << pElem->Child(elem_mat_visibility_anim_info::Id());
        mat_vis_mat_anim_array <<pElem->Child(elem_mat_vis_mat_anim::IdArray());
        stream_array << pElem->Child(elem_stream::IdArray());
        user_data_array << pElem->Child(elem_user_data::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_bone_visibility_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        version << pElem;
        bone_visibility_anim_info << pElem->Child(elem_bone_visibility_anim_info::Id());
        bone_vis_bone_anim_array <<pElem->Child(elem_bone_vis_bone_anim::IdArray());
        stream_array << pElem->Child(elem_stream::IdArray());
        user_data_array << pElem->Child(elem_user_data::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_mat_visibility_anim::PostProcess()
{
    // 参照の解決。
    for (auto iter = mat_vis_mat_anim_array.begin(); iter != mat_vis_mat_anim_array.end(); ++iter)
    {
        if (iter->curve)
        {
            elem_anim_curve& curve = iter->curve.Get();
            try
            {
                int stream_array_size = static_cast<int>(stream_array.size());

                if (stream_array_size <= curve.stream_index.value)
                {
                    THROW_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                        "Out of range. stream_array: %d mat_visibility_anim.stream_index: %d",
                        stream_array_size, curve.stream_index.value);
                }
                // テキストデータを解析します。
                elem_stream& xmlStream = stream_array[curve.stream_index.value];
                curve.stream.rawdata = AnalizeAndCopyData(xmlStream.textData, xmlStream.count.value, xmlStream.GetStreamType());
                curve.stream.count = xmlStream.count.value;
                curve.stream.type = static_cast<StreamType>(xmlStream.type.value);
            }
            CATCH_THROW_XML_ERROR()
        }
    }

    // ユーザーデータの解析
    for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
    {
        iter->PostProcess(stream_array);
    }
}

void elem_mat_visibility_anim::PostBinaryProcess(void* data)
{
    try
    {
        StreamArray streamArray;
        AnalizeBinaryData(streamArray, data);

        int stream_array_size = static_cast<int>(streamArray.streamChunk.size());

        // 参照の解決。
        for (auto iter = mat_vis_mat_anim_array.begin(); iter != mat_vis_mat_anim_array.end(); ++iter)
        {
            if (iter->curve)
            {
                elem_anim_curve& curve = iter->curve.Get();

                if (stream_array_size <= curve.stream_index.value)
                {
                    THROW_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                        "Out of range. stream_array: %d mat_visibility_anim.stream_index: %d",
                        stream_array_size, curve.stream_index.value);
                }
                void* rawdata = CopyRawData(streamArray.streamChunk[curve.stream_index.value]);
                curve.stream.rawdata.reset(rawdata, free);
            }
        }

        for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
        {
            iter->PostBinaryProcess(streamArray);
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_bone_visibility_anim::PostProcess()
{
    // 参照の解決。
    for (auto iter = bone_vis_bone_anim_array.begin(); iter != bone_vis_bone_anim_array.end(); ++iter)
    {
        if (iter->curve)
        {
            elem_anim_curve& curve = iter->curve.Get();
            try
            {
                int stream_array_size = static_cast<int>(stream_array.size());

                if (stream_array_size <= curve.stream_index.value)
                {
                    THROW_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                        "Out of range. stream_array: %d bone_visibility_anim.stream_index: %d",
                        stream_array_size, curve.stream_index.value);
                }
                // テキストデータを解析します。
                elem_stream& xmlStream = stream_array[curve.stream_index.value];
                curve.stream.rawdata = AnalizeAndCopyData(xmlStream.textData, xmlStream.count.value, xmlStream.GetStreamType());
                curve.stream.count = xmlStream.count.value;
            }
            CATCH_THROW_XML_ERROR()
        }
    }

    // ユーザーデータの解析
    for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
    {
        iter->PostProcess(stream_array);
    }
}

void elem_bone_visibility_anim::PostBinaryProcess(void* data)
{
    try
    {
        StreamArray streamArray;
        AnalizeBinaryData(streamArray, data);

        int stream_array_size = static_cast<int>(streamArray.streamChunk.size());

        // 参照の解決。
        for (auto iter = bone_vis_bone_anim_array.begin(); iter != bone_vis_bone_anim_array.end(); ++iter)
        {
            if (iter->curve)
            {
                elem_anim_curve& curve = iter->curve.Get();

                if (stream_array_size <= curve.stream_index.value)
                {
                    THROW_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                        "Out of range. stream_array: %d bone_visibility_anim.stream_index: %d",
                        stream_array_size, curve.stream_index.value);
                }
                void* rawdata = CopyRawData(streamArray.streamChunk[curve.stream_index.value]);
                curve.stream.rawdata.reset(rawdata, free);
                curve.stream.count = streamArray.streamChunk[curve.stream_index.value].count;
                curve.stream.type = streamArray.streamChunk[curve.stream_index.value].type;
            }
        }

        for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
        {
            iter->PostBinaryProcess(streamArray);
        }
    }
    CATCH_THROW_XML_ERROR()
}

void
elem_mat_visibility_anim::CheckData(int /*flag*/)
{

}

void
elem_bone_visibility_anim::CheckData(int /*flag*/)
{

}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
