﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

G3DIF_DEFINE_ENUM_TABLE(
    stream, type,
    S11N_DEFINE_ENUM_ID(float),
    S11N_DEFINE_ENUM_ID(int),
    S11N_DEFINE_ENUM_ID(byte),
    S11N_DEFINE_ENUM_ID(string),
    S11N_DEFINE_ENUM_ID(wstring)
    );

//--------------------------------------------------------------------------------------------------

void elem_stream::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        type << pElem;
        count << pElem;
        const char* str = pElem->Attribute(tbl_identifier[id_column]);
        if (str)
        {
            Read(str, column.value);
        }

        // データへのポインタを入れておく
        textData = pElem->Text();
    }
    CATCH_THROW_XML_ERROR()
}

void AnalizeBinaryData(StreamArray& streamArray, void* data)
{
    void* header = data;
    if (memcmp(header, &STREAM_HEADER_ORDER, sizeof(u64)) != 0)
    {
        THROW_ERROR(ERRCODE_XML_BINARY_STREAM_FAILURE, "Not found binary stream header.");
    }
    streamArray.header = *static_cast<u64*>(header);
    header = util::AddOffset(header, sizeof(u64));

    streamArray.chunkCount = *static_cast<s32*>(header);
    header = util::AddOffset(header, sizeof(s32));
    for (int i = 0; i < static_cast<int>(streamArray.chunkCount); ++i)
    {
        // StreamChunk を構築
        StreamChunk streamChunk;
        ChunkOffset chunkOffset;
        chunkOffset.offset = *static_cast<u32*>(header);
        header = util::AddOffset(header, sizeof(u32));
        chunkOffset.size = *static_cast<s32*>(header);
        header = util::AddOffset(header, sizeof(s32));

        void* streamHeader = util::AddOffset(data, chunkOffset.offset);
        if (memcmp(streamHeader, &STREAM_CHUNK_HEADER_ORDER, sizeof(u64)) != 0)
        {
            THROW_ERROR(ERRCODE_XML_BINARY_STREAM_FAILURE, "Not found binary stream header.");
        }
        streamChunk.header = *static_cast<u64*>(streamHeader);
        streamHeader = util::AddOffset(streamHeader, sizeof(u64));
        streamChunk.type = *static_cast<StreamType*>(streamHeader);
        streamHeader = util::AddOffset(streamHeader, sizeof(s32));
        streamChunk.count = *static_cast<s32*>(streamHeader);
        streamHeader = util::AddOffset(streamHeader, sizeof(s32));
        streamChunk.column = *static_cast<s32*>(streamHeader);
        streamHeader = util::AddOffset(streamHeader, sizeof(s32));
        streamChunk.size = *static_cast<s32*>(streamHeader);
        streamHeader = util::AddOffset(streamHeader, sizeof(s32));
        streamChunk.padding = *static_cast<u64*>(streamHeader);
        streamHeader = util::AddOffset(streamHeader, sizeof(u64));

        streamChunk.data = streamHeader;

        streamArray.chunkOffset.push_back(chunkOffset);
        streamArray.streamChunk.push_back(streamChunk);
    }
}

void* CopyRawData(StreamChunk& streamChunk)
{
    void* pData = nullptr;

    if (streamChunk.type == StreamTypeFloat)
    {
        pData = malloc(streamChunk.count * sizeof(float));
        memcpy(pData, streamChunk.data, streamChunk.count * sizeof(float));
    }
    else if (streamChunk.type == StreamTypeInt)
    {
        pData = malloc(streamChunk.count * sizeof(int));
        memcpy(pData, streamChunk.data, streamChunk.count * sizeof(int));
    }
    else if (streamChunk.type == StreamTypeByte)
    {
        pData = malloc(streamChunk.count);
        memcpy(pData, streamChunk.data, streamChunk.count);
    }
    else if (streamChunk.type == StreamTypeString)
    {
        pData = malloc(streamChunk.size);
        memcpy(pData, streamChunk.data, streamChunk.size);
    }
    else if (streamChunk.type == StreamTypeWString)
    {
        pData = malloc(streamChunk.size);
        memcpy(pData, streamChunk.data, streamChunk.size);
    }
    else
    {
        THROW_ERROR(ERRCODE_XML_INVALID_BINARY_STREAM_TYPE, "Invalid binary stream type.");
    }

    return pData;
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
