﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <g3dif/MaterialAnim.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

void elem_nn_material_anim_info::operator<<(const nw::g3d::tool::util::XMLElement* pElem)
{
    nw::g3d::tool::g3dif::VerifyElement(pElem, Id());

    try
    {
        frame_count << pElem;
        loop << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_tex_pattern_anim::operator<<(const nw::g3d::tool::util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        sampler_name << pElem;
        base_value << pElem;

        curve.Validate();
        if (!curve->Read(pElem))
        {
            curve.Invalidate();
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_param_anim::operator<<(const nw::g3d::tool::util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        id << pElem;
        type << pElem;

        for (const util::XMLElement* pTarget = pElem->Child(elem_param_anim_target::Id());
        pTarget != nullptr; pTarget = pTarget->NextSibling(elem_param_anim_target::Id()))
        {
            param_anim_target_array.push_back(elem_param_anim_target());
            param_anim_target_array.back() << pTarget;
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_material_visibility_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        base_value << pElem;

        curve.Validate();
        if (!curve->Read(pElem))
        {
            curve.Invalidate();
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_per_material_anim::operator<<(const nw::g3d::tool::util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        mat_name << pElem;
        shader_param_anim_array << pElem->Child(elem_nn_param_anim::IdArray());
        tex_pattern_anim_array << pElem->Child(elem_nn_tex_pattern_anim::IdArray());
        material_visibility_anim << pElem->Child(elem_nn_material_visibility_anim::Id());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_original_per_material_anim::operator<<(const util::XMLElement* pElem)
{
    VerifyElement(pElem, Id());

    try
    {
        mat_name << pElem;
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_material_anim::operator<<(const nw::g3d::tool::util::XMLElement* pElem)
{
    nw::g3d::tool::g3dif::VerifyElement(pElem, Id());

    try
    {
        version << pElem;
        material_anim_info << pElem->Child(elem_nn_material_anim_info::Id());
        tex_pattern_array << pElem->Child(elem_tex_pattern::IdArray());
        per_material_anim_array << pElem->Child(elem_nn_per_material_anim::IdArray());
        original_per_mterial_anim_array << pElem->Child(elem_nn_original_per_material_anim::IdArray());
        stream_array << pElem->Child(elem_stream::IdArray());
        user_data_array << pElem->Child(elem_user_data::IdArray());
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_material_anim::PostProcess()
{
    try
    {
        // PerMaterialAnim 配下の参照解決
        for (auto iterPerMatAnim = per_material_anim_array.begin(); iterPerMatAnim != per_material_anim_array.end(); ++iterPerMatAnim)
        {
            if (iterPerMatAnim->shader_param_anim_array)
            {
                for (auto iterShaderParamAnim = iterPerMatAnim->shader_param_anim_array.Get().begin();
                iterShaderParamAnim != iterPerMatAnim->shader_param_anim_array.Get().end();
                    ++iterShaderParamAnim)
                {
                    for (auto iterTarget = iterShaderParamAnim->param_anim_target_array.begin();
                    iterTarget != iterShaderParamAnim->param_anim_target_array.end();
                        ++iterTarget)
                    {
                        if (iterTarget->curve)
                        {
                            elem_anim_curve& curve = iterTarget->curve.Get();
                            try
                            {
                                int stream_array_size = static_cast<int>(stream_array.size());

                                if (stream_array_size <= curve.stream_index.value)
                                {
                                    THROW_TRANSLATED_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                                        "Identifier_OutOfRangeStream",
                                        "shader_param_anim", stream_array_size, curve.stream_index.value);
                                }
                                // テキストデータを解析します。
                                elem_stream& xmlStream = stream_array[curve.stream_index.value];
                                curve.stream.rawdata = AnalizeAndCopyData(xmlStream.textData, xmlStream.count.value, xmlStream.GetStreamType());
                                curve.stream.count = xmlStream.count.value;
                                curve.stream.type = static_cast<StreamType>(xmlStream.type.value);
                            }
                            CATCH_THROW_XML_ERROR()
                        }
                    }
                }
            }

            if (iterPerMatAnim->tex_pattern_anim_array)
            {
                auto& texPatternAnimArray = iterPerMatAnim->tex_pattern_anim_array.Get();
                for (auto iter = texPatternAnimArray.begin(); iter != texPatternAnimArray.end(); ++iter)
                {
                    if (iter->curve)
                    {
                        elem_anim_curve& curve = iter->curve.Get();
                        try
                        {
                            int stream_array_size = static_cast<int>(stream_array.size());

                            if (stream_array_size <= curve.stream_index.value)
                            {
                                THROW_TRANSLATED_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                                    "Identifier_OutOfRangeStream",
                                    "tex_pattern_anim", stream_array_size, curve.stream_index.value);
                            }
                            // テキストデータを解析します。
                            elem_stream& xmlStream = stream_array[curve.stream_index.value];
                            curve.stream.rawdata = AnalizeAndCopyData(xmlStream.textData, xmlStream.count.value, xmlStream.GetStreamType());
                            curve.stream.count = xmlStream.count.value;
                            curve.stream.type = static_cast<StreamType>(xmlStream.type.value);
                        }
                        CATCH_THROW_XML_ERROR()
                    }
                }
            }

            if (iterPerMatAnim->material_visibility_anim)
            {
                auto& matVisAnim = iterPerMatAnim->material_visibility_anim.Get();
                if (matVisAnim.curve)
                {
                    elem_anim_curve& curve = matVisAnim.curve.Get();
                    try
                    {
                        int stream_array_size = static_cast<int>(stream_array.size());

                        if (stream_array_size <= curve.stream_index.value)
                        {
                            THROW_TRANSLATED_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                                "Identifier_OutOfRangeStream",
                                "mat_visibility_anim", stream_array_size, curve.stream_index.value);
                        }
                        // テキストデータを解析します。
                        elem_stream& xmlStream = stream_array[curve.stream_index.value];
                        curve.stream.rawdata = AnalizeAndCopyData(xmlStream.textData, xmlStream.count.value, xmlStream.GetStreamType());
                        curve.stream.count = xmlStream.count.value;
                        curve.stream.type = static_cast<StreamType>(xmlStream.type.value);
                    }
                    CATCH_THROW_XML_ERROR()
                }
            }
        }

        // ユーザーデータの解析
        int idx = 0;
        for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter, ++idx)
        {
            iter->PostProcess(stream_array);
        }
    }
    CATCH_THROW_XML_ERROR()
}

void elem_nn_material_anim::PostBinaryProcess(void* data)
{
    // TODO: fmab の対応
    try
    {
        StreamArray streamArray;
        AnalizeBinaryData(streamArray, data);

        // PerMaterialAnim 配下の参照解決
        for (auto iterPerMatAnim = per_material_anim_array.begin(); iterPerMatAnim != per_material_anim_array.end(); ++iterPerMatAnim)
        {
            if (iterPerMatAnim->shader_param_anim_array)
            {
                for (auto iterShaderParamAnim = iterPerMatAnim->shader_param_anim_array.Get().begin();
                iterShaderParamAnim != iterPerMatAnim->shader_param_anim_array.Get().end();
                    ++iterShaderParamAnim)
                {
                    for (auto iterTarget = iterShaderParamAnim->param_anim_target_array.begin();
                    iterTarget != iterShaderParamAnim->param_anim_target_array.end();
                        ++iterTarget)
                    {
                        if (iterTarget->curve)
                        {
                            elem_anim_curve& curve = iterTarget->curve.Get();
                            try
                            {
                                int stream_array_size = static_cast<int>(streamArray.streamChunk.size());

                                if (stream_array_size <= curve.stream_index.value)
                                {
                                    THROW_TRANSLATED_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                                        "Identifier_OutOfRangeStream",
                                        "shader_param_anim", stream_array_size, curve.stream_index.value);
                                }
                                void* rawdata = CopyRawData(streamArray.streamChunk[curve.stream_index.value]);
                                curve.stream.rawdata.reset(rawdata, free);
                                curve.stream.count = streamArray.streamChunk[curve.stream_index.value].count;
                                curve.stream.type = streamArray.streamChunk[curve.stream_index.value].type;
                            }
                            CATCH_THROW_XML_ERROR()
                        }
                    }
                }
            }

            if (iterPerMatAnim->tex_pattern_anim_array)
            {
                auto& texPatternAnimArray = iterPerMatAnim->tex_pattern_anim_array.Get();
                for (auto iter = texPatternAnimArray.begin(); iter != texPatternAnimArray.end(); ++iter)
                {
                    if (iter->curve)
                    {
                        elem_anim_curve& curve = iter->curve.Get();
                        try
                        {
                            int stream_array_size = static_cast<int>(streamArray.streamChunk.size());

                            if (stream_array_size <= curve.stream_index.value)
                            {
                                THROW_TRANSLATED_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                                    "Identifier_OutOfRangeStream",
                                    "tex_pattern_anim", stream_array_size, curve.stream_index.value);
                            }
                            void* rawdata = CopyRawData(streamArray.streamChunk[curve.stream_index.value]);
                            curve.stream.rawdata.reset(rawdata, free);
                            curve.stream.count = streamArray.streamChunk[curve.stream_index.value].count;
                            curve.stream.type = streamArray.streamChunk[curve.stream_index.value].type;
                        }
                        CATCH_THROW_XML_ERROR()
                    }
                }
            }

            if (iterPerMatAnim->material_visibility_anim)
            {
                auto& matVisAnim = iterPerMatAnim->material_visibility_anim.Get();
                if (matVisAnim.curve)
                {
                    elem_anim_curve& curve = matVisAnim.curve.Get();
                    try
                    {
                        int stream_array_size = static_cast<int>(streamArray.streamChunk.size());

                        if (stream_array_size <= curve.stream_index.value)
                        {
                            THROW_TRANSLATED_ERROR(ERRCODE_XML_OUT_OF_RANGE,
                                "Identifier_OutOfRangeStream",
                                "mat_visibility_anim", stream_array_size, curve.stream_index.value);
                        }
                        void* rawdata = CopyRawData(streamArray.streamChunk[curve.stream_index.value]);
                        curve.stream.rawdata.reset(rawdata, free);
                        curve.stream.count = streamArray.streamChunk[curve.stream_index.value].count;
                        curve.stream.type = streamArray.streamChunk[curve.stream_index.value].type;
                    }
                    CATCH_THROW_XML_ERROR()
                }
            }
        }

        for (auto iter = user_data_array.begin(); iter != user_data_array.end(); ++iter)
        {
            iter->PostBinaryProcess(streamArray);
        }
    }
    CATCH_THROW_XML_ERROR()
}

void
elem_nn_material_anim::CheckData(int flag)
{
    if ( util::CheckFlag(flag, CHECK_PARAM_ANIM_ASSIGN) && ( per_material_anim_array.size() == 0 ) && ( original_per_mterial_anim_array.size() != 0 ) )
    {
        THROW_TRANSLATED_ERROR(ERRCODE_XML_ANIMATION_NOT_FOUND, "Identifier_NotFoundValue", "per_material_anim");
    }

    for (auto iterPattern = tex_pattern_array.cbegin(); iterPattern != tex_pattern_array.cend(); ++iterPattern)
    {
        if (iterPattern->tex_name.value.empty())
        {
            if (util::CheckFlag(flag, CHECK_TEXTURE_NAME))
            {
                THROW_TRANSLATED_ERROR(ERRCODE_XML_TEXTURE_NAME_NOT_FOUND, "Identifier_NotFoundValueIn", "tex_name", "tex_pattern_anim", name.c_str());
            }
        }
    }
}

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
