﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_mat_vis_mat_anim
    {
public:

    elem_mat_vis_mat_anim()
        : mat_name()
        , base_value(0.0f)
    {
    }

    template<typename T>
    elem_mat_vis_mat_anim& operator=(const T& rhs)
    {
        // nw fma 互換では fma の中に shader param と material visi の共存を許可しない
        if( rhs.shader_param_anim_array )
        {
            THROW_ERROR(ERRCODE_INVALID_MATERIAL_ANIM_FILE_TYPE, "Invalid material anim. Material \"%s\" has both shader param and material visibility anim.\n");
        }

        mat_name = rhs.mat_name;

        if( rhs.material_visibility_anim )
        {
            base_value = rhs.material_visibility_anim.Get().base_value;
            curve = rhs.material_visibility_anim.Get().curve;			// 同型でメンバにポインタを含まないのでデフォルトの operator= を呼ぶ
        }

        return *this;
    }
    G3DIF_DEFINE_ELEM_ARRAY(mat_vis_mat_anim);

    G3DIF_DEFINE_ATTRIB(std::string, mat_name);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_bone_vis_bone_anim
{
public:

    elem_bone_vis_bone_anim()
        : bone_name()
        , binarize_visibility(false)
        , base_value(0.0f)
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(bone_vis_bone_anim);

    G3DIF_DEFINE_ATTRIB(std::string, bone_name);
    G3DIF_DEFINE_ATTRIB(bool, binarize_visibility);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    util::Optional<elem_anim_curve> curve;
};

class elem_mat_visibility_anim_info
{
public:

    elem_mat_visibility_anim_info()
        : frame_count(0)
        , loop(true)
    {
    }

    template<typename T>
    elem_mat_visibility_anim_info& operator=(const T& elemNnMatAnimInfo)
    {
        frame_count = elemNnMatAnimInfo.frame_count;
        loop = elemNnMatAnimInfo.loop;
        return *this;
    }

    G3DIF_DEFINE_ELEM(mat_visibility_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
};

class elem_bone_visibility_anim_info
{
public:

    elem_bone_visibility_anim_info()
        : frame_count(0)
        , loop(true)
    {
    }

    G3DIF_DEFINE_ELEM(bone_visibility_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
};

class elem_mat_visibility_anim
{
public:

    elem_mat_visibility_anim()
        : name()
        , path()
        , mat_visibility_anim_info()
        , mat_vis_mat_anim_array()
        , stream_array()
        , user_data_array()
    {
    }

    template<typename T>
    elem_mat_visibility_anim& operator=(const T& rhs)
    {
    	mat_visibility_anim_info = rhs.material_anim_info;

        // shader_param_mat_anim_array
        mat_vis_mat_anim_array.resize( rhs.per_material_anim_array.size() );
        int idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.per_material_anim_array )
        {
            mat_vis_mat_anim_array[idxElem] = elemNnPerMatAnim;
            ++idxElem;
        }

        // stream_array
        stream_array.resize( rhs.stream_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.stream_array )
        {
            stream_array[idxElem] = elemNnPerMatAnim;		// デフォルトの operator= を使用する。
            ++idxElem;
        }

        // user_data_array
        user_data_array.resize( rhs.user_data_array.size() );
        idxElem = 0;
        for( auto& elemNnPerMatAnim : rhs.user_data_array )
        {
            user_data_array[idxElem] = elemNnPerMatAnim;	// デフォルトの operator= を使用する。
            ++idxElem;
        }

    	return *this;
    }

    G3DIF_DEFINE_ELEM(mat_visibility_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_mat_visibility_anim_info mat_visibility_anim_info;
    std::vector<elem_mat_vis_mat_anim> mat_vis_mat_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

class elem_bone_visibility_anim
{
public:

    elem_bone_visibility_anim()
        : name()
        , path()
        , bone_visibility_anim_info()
        , bone_vis_bone_anim_array()
        , stream_array()
        , user_data_array()
    {
    }

    G3DIF_DEFINE_ELEM(bone_visibility_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

    elem_bone_visibility_anim_info bone_visibility_anim_info;
    std::vector<elem_bone_vis_bone_anim> bone_vis_bone_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
