﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/Stream.h>
#include <g3dif/UserData.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

//--------------------------------------------------------------------------------------------------

class elem_submesh
{
public:
    elem_submesh() : offset(0), count(0) {}

    G3DIF_DEFINE_ELEM_ARRAY(submesh);

    G3DIF_DEFINE_ATTRIB(int, offset);
    G3DIF_DEFINE_ATTRIB(int, count);
};

class elem_mesh
{
public:
    G3DIF_DEFINE_ENUM(mode,
        triangles,
        triangle_fan,
        triangle_strip
    );

    G3DIF_DEFINE_ENUM(quantize_type,
        none,
        uint16,
        uint32
    );

    elem_mesh()
        : mode(triangles)
        , quantize_type(uint32)
        , count(0)
        , stream_index(-1)
        , offset(0)
        , stream()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(mesh);

    G3DIF_DEFINE_ATTRIB(enum_mode, mode);
    G3DIF_DEFINE_ATTRIB(enum_quantize_type, quantize_type);
    G3DIF_DEFINE_ATTRIB(int, count);
    G3DIF_DEFINE_ATTRIB(int, stream_index);

    std::vector<elem_submesh> submesh_array;
    int offset; // lod_offset

    DataStream stream;
};

class elem_target_attrib
{
public:
    elem_target_attrib()
        : attrib_name()
        , attrib_index(-1)
        , attrib_hint()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(target_attrib);

    G3DIF_DEFINE_ATTRIB(std::string, attrib_name);

    int attrib_index;
    std::string attrib_hint;
};

class elem_key_shape
{
public:
    elem_key_shape()
        : name()
        , target_attrib_array()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(key_shape);

    G3DIF_DEFINE_ATTRIB(std::string, name);

    std::vector<elem_target_attrib> target_attrib_array;
};

//--------------------------------------------------------------------------------------------------

class elem_shape_info
{
public:
    elem_shape_info()
        : mat_name()
        , bone_name()
        , vertex_index(-1)
        , vertex_skinning_count(0)
        , bone_index(-1)
        , mat_index(-1)
        , vertex_count(0)
        , mesh_adjacency(false)
    {
    }

    G3DIF_DEFINE_ELEM(shape_info);

    G3DIF_DEFINE_ATTRIB(std::string, mat_name);
    G3DIF_DEFINE_ATTRIB(std::string, bone_name);
    G3DIF_DEFINE_ATTRIB(int, vertex_index);
    G3DIF_DEFINE_ATTRIB(int, vertex_skinning_count);

    int bone_index;
    int mat_index;
    uint vertex_count;
    bool mesh_adjacency;
};

//--------------------------------------------------------------------------------------------------

class elem_shape
{
public:
     elem_shape()
         : name()
         , shape_info()
         , mesh_array()
         , key_shape_array()
         , user_data_array() {}

    G3DIF_DEFINE_ELEM_ARRAY(shape);

    G3DIF_DEFINE_ATTRIB(std::string, name);

    void PostProcess(std::vector<elem_stream>& stream_array);
    void PostBinaryProcess(StreamArray& streamArray);

    elem_shape_info shape_info;
    std::vector<elem_mesh> mesh_array;
    std::vector<elem_key_shape> key_shape_array;
    std::vector<elem_user_data> user_data_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
