﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class VariationValue
{
public:
    std::string choice;
    std::string default_value;
    bool branch;
};

typedef std::unordered_map<std::string, VariationValue> filter_map;

class elem_stage
{
public:
    elem_stage()
        : path()
    {}

    G3DIF_DEFINE_ELEM(shader_path);

    // ステージ別の id 取得
    static const nw::g3d::tool::util::LiteralStr& Id(int stage)
    {
        return nw::g3d::tool::g3dif::tbl_identifier[GetIdentifier(stage)];
    }

    static const Identifier GetIdentifier(int stage)
    {
        switch (stage)
        {
        case ShaderStage_Vertex:
            return nw::g3d::tool::g3dif::id_vertex_shader;
        case ShaderStage_Geometry:
            return nw::g3d::tool::g3dif::id_geometry_shader;
        case ShaderStage_Fragment:
            return nw::g3d::tool::g3dif::id_fragment_shader;
        case ShaderStage_Compute:
            return nw::g3d::tool::g3dif::id_compute_shader;
        default:
            break;
        }
        THROW_ERROR(ERRCODE_INTERNAL, "internal error");
        return nw::g3d::tool::g3dif::id_nw4f_3dif;
    }

    G3DIF_DEFINE_ATTRIB(std::string, path);
};

class elem_macro
{
public:
    elem_macro()
        : name()
        , value()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(macro);

    G3DIF_DEFINE_ATTRIB(std::string, name);
    G3DIF_DEFINE_ATTRIB(std::string, value);
};

class elem_include_path
{
public:
    elem_include_path()
        : path()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(include_path);

    G3DIF_DEFINE_ATTRIB(std::string, path);
};

class elem_force_include_file
{
public:
    elem_force_include_file()
        : path()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(force_include_file);

    G3DIF_DEFINE_ATTRIB(std::string, path);
};

class elem_variation
{
public:
    elem_variation()
        : id()
        , choice()
        , default_value()
        , branch(false)
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(variation);

    G3DIF_DEFINE_ATTRIB(std::string, id);
    G3DIF_DEFINE_ATTRIB(std::string, choice);
    // default が予約語なので別名で受け取る。
    util::Attribute<std::string, id_default> default_value;
    G3DIF_DEFINE_ATTRIB(bool, branch);
};

class elem_shader
{
public:
    elem_shader()
        : name()
        , material_shader(true)
        , shader_path()
        , macro_array()
        , variation_array()
        , option_filter()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(shader);

    G3DIF_DEFINE_ATTRIB(std::string, name);
    G3DIF_DEFINE_ATTRIB(bool, material_shader);

    util::Optional<elem_stage> shader_path[ShaderStage_StageCount];
    std::vector<elem_macro> macro_array;
    std::vector<elem_variation> variation_array;
    filter_map option_filter;

    void Expand();
};

class elem_shader_config_info
{
public:
    elem_shader_config_info()
        : code_page(UINT_MAX)
    {
    }

    G3DIF_DEFINE_ELEM(shader_config_info);

    G3DIF_DEFINE_ATTRIB(int, code_page);
};

//--------------------------------------------------------------------------------------------------

class elem_shader_config
{
public:
    elem_shader_config()
        : name()
        , path()
        , relative_path()
        , include_path_array()
        , force_include_file_array()
        , shader_array()
    {
    }

    G3DIF_DEFINE_ELEM(shader_config);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void SetName(const char* fileName) { this->name.assign(fileName); };
    void SetPath(const char* filePath) { this->path.assign(filePath); }
    void SetRelativePath(const char* filePath) { this->relative_path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;
    std::string relative_path;

    elem_shader_config_info shader_config_info;
    std::vector<elem_include_path> include_path_array;
    std::vector<elem_force_include_file> force_include_file_array;
    std::vector<elem_shader> shader_array;
};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
