﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <g3dif/Serialization.h>
#include <g3dif/AnimCurve.h>
#include <g3dif/UserData.h>
#include <g3dif/Stream.h>
#include <g3dif/Material.h>
#include <g3dif/ShaderParamAnim.h>
#include <g3dif/TexPatternAnim.h>
#include <g3dif/VisibilityAnim.h>
#include <g3dif/Material.h>

namespace nw { namespace g3d { namespace tool {
namespace g3dif {

class elem_nn_material_anim_info
{
public:
    elem_nn_material_anim_info() :
        frame_count(0)
        , loop(true)
    {
    }

    G3DIF_DEFINE_ELEM(nn_material_anim_info);

    G3DIF_DEFINE_ATTRIB(int, frame_count);
    G3DIF_DEFINE_ATTRIB(bool, loop);
};


class elem_nn_tex_pattern_anim
{
public:
    elem_nn_tex_pattern_anim()
        : sampler_name()
        , base_value(0.0f)
        , curve()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(nn_tex_pattern_anim);

    G3DIF_DEFINE_ATTRIB(std::string, sampler_name);
    G3DIF_DEFINE_ATTRIB(float, base_value);

    nw::g3d::tool::util::Optional<nw::g3d::tool::g3dif::elem_anim_curve> curve;
};

class elem_nn_material_visibility_anim
{
public:

    elem_nn_material_visibility_anim()
        : base_value(0.0f)
    {
    }

    G3DIF_DEFINE_ELEM(nn_material_visibility_anim);

    G3DIF_DEFINE_ATTRIB(float, base_value);

    nw::g3d::tool::util::Optional<nw::g3d::tool::g3dif::elem_anim_curve> curve;
};

class elem_nn_param_anim
{
public:

    elem_nn_param_anim()
        : id()
        , type(nw::g3d::tool::g3dif::elem_shader_param::type_float4)
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(nn_param_anim);

    G3DIF_DEFINE_ATTRIB(std::string, id);
    G3DIF_DEFINE_ATTRIB(nw::g3d::tool::g3dif::elem_shader_param::enum_type, type);

    std::vector<nw::g3d::tool::g3dif::elem_param_anim_target> param_anim_target_array;	//!< TODO: parm_anim_target は必要か？
};

class elem_nn_per_material_anim
{
public:
    elem_nn_per_material_anim()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(nn_per_material_anim);

    G3DIF_DEFINE_ATTRIB(std::string, mat_name);

    util::Optional<std::vector<elem_nn_param_anim>> shader_param_anim_array;			//!< TODO: nw の elem_param_anim と同じ
    util::Optional<std::vector<elem_nn_tex_pattern_anim>> tex_pattern_anim_array;
    util::Optional<elem_nn_material_visibility_anim> material_visibility_anim;
};

class elem_nn_original_per_material_anim
{
public:
    elem_nn_original_per_material_anim() :
        mat_name()
    {
    }

    G3DIF_DEFINE_ELEM_ARRAY(nn_original_per_material_anim);
    G3DIF_DEFINE_ATTRIB(std::string, mat_name);
};

class elem_nn_material_anim
{
public:

    elem_nn_material_anim()
        : name()
        , path()
        , material_anim_info()
        , tex_pattern_array()
        , per_material_anim_array()
        , original_per_mterial_anim_array()
        , stream_array()
    {
    }

    G3DIF_DEFINE_ELEM(nn_material_anim);

    G3DIF_DEFINE_ATTRIB(Version, version);

    void PostProcess();
    void PostBinaryProcess(void* data);
    void SetName(const char* fileName) { this->name.assign(fileName); }
    void SetPath(const char* filePath) { this->path.assign(filePath); }

    //! 読み込んだデータの整合性を確認します。
    void CheckData(int flag);

    std::string name;
    std::string path;

#if 0
    elem_shader_param_anim_info shader_param_anim_info;
    std::vector<elem_shader_param_mat_anim> shader_param_mat_anim_array;
    std::vector<elem_original_material_anim> original_material_anim_array;
    std::vector<elem_stream> stream_array;
    std::vector<elem_user_data> user_data_array;
#endif

    elem_nn_material_anim_info material_anim_info;
    std::vector<elem_tex_pattern>	tex_pattern_array;	//!< 従来とパラメータは同じなので流用できる。
    std::vector<elem_nn_per_material_anim>	per_material_anim_array;
    std::vector<elem_nn_original_per_material_anim> original_per_mterial_anim_array;
    std::vector<nw::g3d::tool::g3dif::elem_stream> stream_array;
    std::vector<nw::g3d::tool::g3dif::elem_user_data> user_data_array;

};

} // namespace g3dif

} // namespace tool
} // namespace g3d
} // namespace nw
