﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/gfxTool/gfxTool_CommandLineParser.h>

namespace nn {
namespace g3dTool {

class GlobalOptionParserBase : public nn::gfxTool::CommandLineParser
{
public:
    //! @brief コマンドラインオプションを定義する構造体です。
    struct CommandLineOptionDefinitions
    {
        nn::gfxTool::CommandLineOption<> version;
        nn::gfxTool::CommandLineOption<> help;
        nn::gfxTool::CommandLineOption<> silent;
        nn::gfxTool::CommandLineOption<> preProcess;
        nn::gfxTool::CommandLineOption<> verify;
        nn::gfxTool::CommandLineOption<> unifiedAnnotation;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > rootConfig;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > rootDefinition;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > output;
        nn::gfxTool::CommandLineOption<> forceVariation;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > dumpShaderSource;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > dumpStatisticsInformation;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type > glslVersion;
        nn::gfxTool::CommandLineOption< nn::gfxTool::Custom< std::string >::Type[] > defineMacro;
        nn::gfxTool::CommandLineOption<> autoExtract;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> apiType;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> codeType;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> debugInfoLevel;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> debugInfoDirectory;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> shaderCacheDirectory;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> shaderCacheWriteDirectory;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> shaderCacheReadDirectory;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> glslExtension;
        nn::gfxTool::CommandLineOption<> usePreprocessorVariation;
        nn::gfxTool::CommandLineOption<> decomposeBinary;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> jobs;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> glslcOptionFlags;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> gfxShaderConverterOptions;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> variationBeginRatio;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type> variationEndRatio;
        nn::gfxTool::CommandLineOption<> skipConvert;
        nn::gfxTool::CommandLineOption<nn::gfxTool::Custom<std::string>::Type[]> mergeShaderArchiveFile;
    };

    GlobalOptionParserBase()
    {
    }

    virtual ~GlobalOptionParserBase()
    {
    }

    //! @brief 位置引数を取得します。
    const nn::gfxTool::Custom< std::vector< nn::gfxTool::Custom< std::string >::Type > >::Type&
    GetInputArgs() const
    {
        return m_InputArgArray;
    }

    //! @brief コマンドラインオプションを取得します。
    const CommandLineOptionDefinitions& GetCommandLineOptionDefinitions() const
    {
        return m_OptionDefinitions;
    }

    //! @brief コマンドラインオプションを取得します。
    CommandLineOptionDefinitions& GetCommandLineOptionDefinitions()
    {
        return m_OptionDefinitions;
    }

    //!< @brief パースします。
    void Parse( const std::vector< std::string >& srcStrArray )
    {
        const char** strPtrArray = new( const char* [ srcStrArray.size() ] );
        for( int idx = 0; idx < static_cast< int >( srcStrArray.size() ); ++idx )
        {
            strPtrArray[ idx ] = reinterpret_cast< const char* const >( srcStrArray[ idx ].c_str() );
        }
        nn::gfxTool::CommandLineParser::Parse( static_cast< int >( srcStrArray.size() ), strPtrArray );
        delete[] strPtrArray;
    }

    //!< @brief ヘルプを表示します。
    virtual void PrintHelp( const char* pToolName, const char* pToolDescription )
    {
        NN_UNUSED( pToolDescription );
        NN_UNUSED( pToolName );
    }

protected:
    //! @brief オプションの定義と値を保持するオブジェクトです。
    CommandLineOptionDefinitions	m_OptionDefinitions;

    //! @brief 位置引数（オプションを伴わない引数）の配列です。
    nn::gfxTool::Custom< std::vector< nn::gfxTool::Custom< std::string >::Type > >::Type	m_InputArgArray;	//!< オプションの状態と値を保持している配列です。

};

}
}
