﻿#----------------------------------------------------------------------------
# Project:  NintendoWare
#
# Copyright (C)Nintendo All rights reserved.
#
# These coded instructions, statements, and computer programs contain proprietary
# information of Nintendo and/or its licensed developers and are protected by
# national and international copyright laws. They may not be disclosed to third
# parties or copied or duplicated in any form, in whole or in part, without the
# prior written consent of Nintendo.
#
# The content herein is highly confidential and should be handled accordingly.
#----------------------------------------------------------------------------

# 中間ファイルの更新、System.Xml.XmlDocument 型の doc を更新します
def Update(doc):

	# fsd 以外の <nw4f_3dif> version を 3.1.0 に変更します。
	if not doc.SelectSingleNode("/nw4f_3dif/shader_definition"):
		version = doc.SelectSingleNode("/nw4f_3dif/@version")
		version.Value = "3.1.0"

	# モデルの更新
	model = doc.SelectSingleNode("/nw4f_3dif/model")
	if model:
		UpdateModel(doc, model)
		return

#==========================================================
# モデルの更新
def UpdateModel(doc, model):

	# <shader_assign> の mesh_adjacency を追加します。
	# 関連する <shape_info> の binarize_adjacency を全て参照し、
	# true が設定されていれば true を設定します。
	for shader_assign in model.SelectNodes("material_array/material/shader_assign"):
		mat_name = shader_assign.ParentNode.GetAttribute("name")
		for shape_info in model.SelectNodes("shape_array/shape/shape_info[@mat_name = \"%s\"]" % (mat_name)):
			if shape_info.GetAttribute("binarize_adjacency") == "true":
				shader_assign.SetAttribute("mesh_adjacency", "true")
				break
		if not shader_assign.HasAttribute("mesh_adjacency"):
			shader_assign.SetAttribute("mesh_adjacency", "false")


	for shape_info in model.SelectNodes("shape_array/shape/shape_info"):
		# <shape_info> に local_coordinate を追加します。
		# vertex_skinning_count が 1 以下なら true を、そうでなければ false を設定します。
		vertex_skinning_count = int(shape_info.GetAttribute("vertex_skinning_count"))
		if vertex_skinning_count <= 1:
			shape_info.SetAttribute("local_coordinate", "true")
		else:
			shape_info.SetAttribute("local_coordinate", "false")


		# <shape_info> の binarize_adjacency を削除します。
		shape_info.RemoveAttribute("binarize_adjacency")


#==========================================================
