﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::Drawing;
using namespace System::Drawing::Imaging;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;
using namespace nw::g3d::nw4f_3dif;
using namespace nw::g3d::iflib;

namespace nw
{
namespace g3d
{
namespace iftexutil
{
namespace cafe
{

class RSurface;

public ref class Converter : ITextureConverter
{
public:
    Converter();

    // base パスには 3dTextureConterterTexUtils.dll または
    // NW4F_g3dtexcvtr_texUtils.dll のディレクトリのパスを指定する
    virtual bool Initialize(array<String^>^ basePath);
    virtual void Destroy();

    // ガンマ補正するかどうか？
    // デフォルトは true
    property bool IsGammaCorrection
    {
        bool get()
        {
            return isGammaCorrection_;
        }

        void set(bool value)
        {
            isGammaCorrection_ = value;
        }
    }

    property bool IsDllLoaded
    {
        bool get()
        {
            return isDllLoaded_;
        }
    }

    //[System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual property String^ PlatformName{
        String^ get()
        {
            return gcnew String("CafeImage");
        }
    }

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<Bitmap ^>^ ConvertTo1d2dBitmap(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<Bitmap ^> ^>^ ConvertTo3dBitmap(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<Bitmap ^> ^>^ ConvertToCubeBitmap(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<Bitmap ^> ^>^ ConvertTo1dArrayBitmap(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<Bitmap ^> ^>^ ConvertTo2dArrayBitmap(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<Bitmap ^> ^>^ ConvertToCubeArrayBitmap(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<TextureData ^>^ ConvertTo1d2dStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<TextureData ^> ^>^ ConvertTo3dStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<TextureData ^> ^>^ ConvertToCubeStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<TextureData ^> ^>^ ConvertTo1dArrayStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<TextureData ^> ^>^ ConvertTo2dArrayStream(textureType ^texture, List<G3dStream ^> ^streams);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    virtual array<array<TextureData ^> ^>^ ConvertToCubeArrayStream(textureType ^texture, List<G3dStream ^> ^streams);
private:
    bool isInitialized_;
    bool isGammaCorrection_;
    bool isDllLoaded_;

    bool LoadDll(array<String^>^ basePath);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<Bitmap ^> ^>^ ConvertToCubeBitmapInternal(textureType ^texture, List<G3dStream ^> ^streams, bool isCubeArray);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<Bitmap ^>^ ConvertToBitmapLinear(		textureType ^texture, RSurface &detiledSurface, int depthLevel, const unsigned char *gammaCorrectTable[4]);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<Bitmap ^>^ ConvertToBitmapCompress(	textureType ^texture, RSurface &detiledSurface, int depthLevel, const unsigned char *gammaCorrectTable[4]);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<Bitmap ^>^ ConvertToBitmapLinear3d(	textureType ^texture, RSurface &detiledSurface, int mipmapLevel, const unsigned char *gammaCorrectTable[4]);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<Bitmap ^>^ ConvertToBitmapCompress3d(	textureType ^texture, RSurface &detiledSurface, int mipmapLevel, const unsigned char *gammaCorrectTable[4]);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    Bitmap^ ConvertToBitmapLinearInternal(		textureType ^texture, RSurface &detiledSurface, int depthLevel, const unsigned char *gammaCorrectTable[4], bool isHintNormal, float bpp, int mipmapLevel);



    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    Bitmap^ ConvertToBitmapCompressInternal(	textureType ^texture, RSurface &detiledSurface, int depthLevel, const unsigned char *gammaCorrectTable[4], bool isHintNormal, float bpp, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<array<TextureData ^> ^>^ ConvertToCubeStreamInternal(textureType ^texture, List<G3dStream ^> ^streams, bool isCubeArray);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamLinear(		textureType ^texture, RSurface &detiledSurface, int depthLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamCompress(	textureType ^texture, RSurface &detiledSurface, int depthLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamPvrCompress(textureType ^texture, List<G3dStream ^> ^streams, int depthLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamLinear3d(	textureType ^texture, RSurface &detiledSurface, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    array<TextureData ^>^ ConvertToStreamCompress3d(	textureType ^texture, RSurface &detiledSurface, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    TextureData^ ConvertToStreamLinearInternal(		textureType ^texture, RSurface &detiledSurface, int depthLevel, bool isHintNormal, float bpp, int mipmapLevel);

    [System::Security::Permissions::EnvironmentPermissionAttribute(System::Security::Permissions::SecurityAction::LinkDemand)]
    TextureData^ ConvertToStreamCompressInternal(	textureType ^texture, RSurface &detiledSurface, int depthLevel, bool isHintNormal, float bpp, int mipmapLevel);
};

} //namespace cafe
} //namespace texutils
} //namespace g3d
} //namespace nw
