﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;
using System;

namespace nw.g3d.nw4f_3dif
{
    public partial class nw4f_3difType
    {
        /// <summary>
        /// バージョン文字列
        /// </summary>
        public const string Version = G3dConstant.Version;

        /// <summary>
        /// ルート要素
        /// </summary>
        [XmlIgnore]
        public IG3dRootElement RootElement
        {
            get
            {
                return this.Item as IG3dRootElement;
            }
            set
            {
                this.Item = value;
            }
        }

        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            IG3dRootElement rootElement = this.RootElement;
            if (rootElement != null) { rootElement.UpdateArrayHint(); }
        }
    }
}
