﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// 中間ファイルのルート要素
    /// </summary>
    public interface IG3dRootElement
    {
        /// <summary>
        /// 一括処理ログ配列
        /// </summary>
        process_log_arrayType process_log_array { get; set; }

        /// <summary>
        /// ユーザーデータ配列
        /// </summary>
        user_data_arrayType user_data_array { get; set; }

        /// <summary>
        /// ストリーム配列
        /// </summary>
        stream_arrayType stream_array { get; set; }

        /// <summary>
        /// コメント
        /// </summary>
        commentType comment { get; set; }

        /// <summary>
        /// ツールデータ
        /// </summary>
        tool_dataType tool_data { get; set; }

        /// <summary>
        /// ユーザーツールデータ
        /// </summary>
        user_tool_dataType user_tool_data { get; set; }

        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        void UpdateArrayHint();
    }

    public partial class modelType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class materialType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class textureType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class skeletal_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class material_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class shader_param_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class tex_pattern_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class bone_visibility_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class mat_visibility_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class shape_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class scene_animType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }
    }

    public partial class combiner_shaderType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }

        /// <summary>
        /// 一括処理ログ配列
        /// </summary>
        public process_log_arrayType process_log_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーデータ配列
        /// </summary>
        public user_data_arrayType user_data_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public commentType comment
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ツールデータ
        /// </summary>
        public tool_dataType tool_data
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーツールデータ
        /// </summary>
        public user_tool_dataType user_tool_data
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ストリーム
        /// </summary>
        public stream_arrayType stream_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }
    }

    public partial class shader_configType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }

        /// <summary>
        /// 一括処理ログ配列
        /// </summary>
        public process_log_arrayType process_log_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーデータ配列
        /// </summary>
        public user_data_arrayType user_data_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public commentType comment
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーツールデータ
        /// </summary>
        public user_tool_dataType user_tool_data
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }
    }

    public partial class shader_definitionType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }

        /// <summary>
        /// 一括処理ログ配列
        /// </summary>
        public process_log_arrayType process_log_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーデータ配列
        /// </summary>
        public user_data_arrayType user_data_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public commentType comment
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーツールデータ
        /// </summary>
        public user_tool_dataType user_tool_data
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }
    }

    public partial class shader_variationType : IG3dRootElement
    {
        /// <summary>
        /// 配列ヒントの更新
        /// </summary>
        public void UpdateArrayHint()
        {
            G3dArrayHintUpdater.Update(this);
        }

        /// <summary>
        /// 一括処理ログ配列
        /// </summary>
        public process_log_arrayType process_log_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// ユーザーデータ配列
        /// </summary>
        public user_data_arrayType user_data_array
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public commentType comment
        {
            get { return null; }
            set { if (value != null) { throw new InvalidOperationException(); } }
        }
    }
}
