﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// カーブ
    /// </summary>
    public interface IG3dCurve : IG3dStreamReference
    {
        /// <summary>
        /// キーの個数
        /// </summary>
        int count { get; set; }

        /// <summary>
        /// プリラップ
        /// </summary>
        curve_wrapType pre_wrap { get; set; }

        /// <summary>
        /// ポストラップ
        /// </summary>
        curve_wrapType post_wrap { get; set; }
    }

    /// <summary>
    /// 量子化カーブ
    /// </summary>
    public interface IG3dQuantizedCurve : IG3dCurve
    {
        /// <summary>
        /// フレームの量子化精度
        /// </summary>
        curve_frame_typeType frame_type { get; set; }

        /// <summary>
        /// キーの量子化精度
        /// </summary>
        curve_key_typeType key_type { get; set; }

        /// <summary>
        /// 量子化値のスケール
        /// </summary>
        float scale { get; set; }

        /// <summary>
        /// 量子化値のオフセット
        /// </summary>
        float offset { get; set; }
    }

    //=====================================================================
    public partial class hermite_curveType : IG3dQuantizedCurve { }

    public partial class linear_curveType : IG3dQuantizedCurve { }

    public partial class step_curveType : IG3dQuantizedCurve { }

    public partial class original_hermiteType : IG3dCurve { }

    public partial class original_linearType : IG3dCurve { }

    public partial class original_stepType : IG3dCurve { }
}
