﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// 圧縮可能な要素
    /// </summary>
    public interface IG3dCompressibleElement
    {
        /// <summary>
        /// 圧縮可能か
        /// </summary>
        bool compress_enable { get; set; }
    }

    /// <summary>
    /// 圧縮可能なマテリアル
    /// </summary>
    public interface IG3dCompressibleMaterial : IG3dCompressibleElement { }

    /// <summary>
    /// 圧縮可能なボーン
    /// </summary>
    public interface IG3dCompressibleBone : IG3dCompressibleElement { }

    //=====================================================================
    public partial class material_infoType : IG3dCompressibleMaterial { }

    public partial class boneType : IG3dCompressibleBone { }

    public partial class bone_animType : IG3dCompressibleBone { }

    public partial class bone_vis_bone_animType : IG3dCompressibleBone { }
}
