﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Xml;

namespace nw.g3d.nw4f_3dif
{
    /// <summary>
    /// アニメーション情報
    /// </summary>
    public interface IG3dAnimationInfo
    {
        /// <summary>
        /// フレーム解像度
        /// </summary>
        int frame_resolution { get; set; }

        /// <summary>
        /// DCC 開始フレーム
        /// </summary>
        int dcc_start_frame { get; set; }

        /// <summary>
        /// DCC 終了フレーム
        /// </summary>
        int dcc_end_frame { get; set; }

        /// <summary>
        /// DCC フレームレート
        /// </summary>
        float dcc_fps { get; set; }

        /// <summary>
        /// 全ベイクフラグ
        /// </summary>
        bool bake_all { get; set; }
    }

    public interface IG3dAnimationFrameInfo
    {
        /// <summary>
        /// フレーム数
        /// </summary>
        int frame_count { get; set; }

        /// <summary>
        /// ループするか
        /// </summary>
        bool loop { get; set; }
    }

    public interface IG3dShaderParamAnimInfo : IG3dAnimationInfo, IG3dAnimationFrameInfo
    {
        float quantize_tolerance_tex_rotate { get; set; }

        float quantize_tolerance_tex_scale { get; set; }

        float quantize_tolerance_tex_translate { get; set; }
    }

    //=====================================================================
    public partial class skeletal_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo { }

    public partial class shader_param_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo, IG3dShaderParamAnimInfo { }

    public partial class tex_pattern_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo { }

    public partial class bone_visibility_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo { }

    public partial class mat_visibility_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo { }

    public partial class material_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo, IG3dShaderParamAnimInfo { }

    public partial class shape_anim_infoType : IG3dAnimationInfo, IG3dAnimationFrameInfo { }

    public partial class scene_anim_infoType : IG3dAnimationInfo { }

    public partial class camera_animType : IG3dAnimationFrameInfo { }

    public partial class light_animType : IG3dAnimationFrameInfo { }

    public partial class fog_animType : IG3dAnimationFrameInfo { }
}
