﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using nw4f.meshlib;
using nw4f.tinymathlib;
using System.Diagnostics;

namespace nw4f.meshlib
{
    public partial class QemSimp
    {
        private void PostExecute()
        {
            try
            {
                // 境界ボリュームの計算を行います
                mMesh.ComputeBounds();
                foreach (var pmap in propMaps)
                {
                    pmap.Revert(mMesh, true);
                }

                // 頂点共有を行わない場合
                // 不要頂点を削除して、法線や接線の再計算を行う
                // 出力前のアトリビュートの再整理(ストリーム長の整合性を取る)は、FaceAttributeRearrangerで行う
                // 行わない場合、fmdbは不正となるので注意
                if (OptPosPolicy != QemOptPos.ZeroOne)
                {
                    mMesh.RemoveUnusedVertex();
                    mMesh.RecomputeVertexNormals(null);
                    // 浮きエッジ周辺の法線はゼロになる
                    // または未参照データだとゼロになる
                    // なので、強制的に(0,1,0)を入れて丸める
                    mMesh.NormalizeNormals(true);
                    if (RecalcTangentBasis)
                    {
                        mMesh.ComputeTangentBasis();
                    }
                }

                {
                    mMesh.ReComputeSubMeshArray(true);
                    mMesh.FacePropsCountEqualityTest();
                }
                // 境界ボリュームの計算を行います
                mMesh.ComputeBounds();

                TestOut();
            }
            catch (Exception ex)
            {
                throw ExcepHandle.CreateException(ex);
                throw;
            }
        }
    }
}
