﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using Nintendo.G3dTool.Entities;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Serialization;

namespace nw.g3d.iflib.nw3de
{
    /// <summary>
    /// 3DEditor の追加参照パス (nw3de は3DEditor のツールデータ用の接頭語)
    /// </summary>
    [Serializable]
    public class nw3de_SearchPath : ToolDataObject
    {
        [Serializable]
        public class SearchPath
        {
            // 参照フォルダ
            [XmlText]
            public string Path { get; set; }

            // フォルダ以下を検索するか？
            [XmlAttribute]
            public bool Recursive { get; set; }
        }

        public List<SearchPath> SearchPaths { get; set; }

        public nw3de_SearchPath()
        {
            SearchPaths = new List<SearchPath>();
        }
    }
}
