﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using nw.g3d.nw4f_3dif;

namespace nw.g3d.iflib
{
    public class IfShapeAnimQuantizationAnalysis
    {
        // シェイプアニメーションの量子化分析
        public static IfQuantizationAnalysisResult Analyse(
            shape_anim_infoType shapeAnimInfo,
            IfAnimCurve curve,
            bool forceAnalyse)
        {
            IfQuantizationAnalysisResult result = new IfQuantizationAnalysisResult();

            // 量子化判定を途中で打ち切っても元の量子化設定が反映されるように
            // 最初の段階の設定を結果にコピーしておく。
            result.frameType = curve.frameType;
            result.keyType = curve.keyType;
            result.scale = curve.scale;
            result.offset = curve.offset;
            result.skipped = true;

            // keytype が none 以外の場合は key 量子化の判定を行わない。
            if (!forceAnalyse &&
                (curve.keyType != curve_key_typeType.none || !curve.HasCurve()))
            {
                return result;
            }
            result.skipped = false;
            curve.EvalQuantizeFrame(0.5f / shapeAnimInfo.frame_resolution);
            result.frameType = curve.frameType;

            // カーブを量子化します。
            curve.QuantizeCurve();

            result.keyType = curve.keyType;
            result.scale = curve.scale;
            result.offset = curve.offset;

            return result;
        }
    }
}
